/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.util.Random;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.testsuite.TestBase;

public class Test2
extends TestBase {
    private static boolean m_Done;
    private static volatile Random rnd;
    private static volatile byte[] m_ReceiveBuffer;
    private static volatile int m_BytesReceived;
    private static volatile int m_TotalReceived;
    private static volatile long m_T0;
    private static volatile long m_T1;
    private static volatile int m_TxCount;
    private static volatile int m_RxCount;
    private static volatile int m_ErrorCount;
    private static int N;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run(int speed) throws Exception {
        try {
            m_Done = false;
            rnd = new Random();
            m_BytesReceived = 0;
            m_TotalReceived = 0;
            m_TxCount = 0;
            m_RxCount = 0;
            m_ErrorCount = 0;
            Test2.begin("Test2 - tx/rx with event listener");
            Test2.openPort();
            m_Port.notifyOnDataAvailable(true);
            m_Port.notifyOnOutputEmpty(true);
            m_Port.setFlowControlMode(12);
            m_Port.setSerialPortParams(speed, 8, 1, 0);
            boolean[] stop = new boolean[]{false};
            m_T0 = System.currentTimeMillis();
            m_Port.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent event) {
                    try {
                        byte[] buffer;
                        if (event.getEventType() == 1) {
                            buffer = new byte[TestBase.m_In.available()];
                            int n = TestBase.m_In.read(buffer);
                            if (!m_Done) {
                                m_TotalReceived += n;
                                Test2.processBuffer(buffer, n);
                                if (m_RxCount >= N) {
                                    m_Done = true;
                                }
                            }
                        }
                        if (event.getEventType() == 2 && m_TxCount < N) {
                            buffer = Test2.generateRandomMessage();
                            TestBase.m_Out.write(buffer, 0, buffer.length);
                            m_TxCount++;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            while (!m_Done) {
                try {
                    Test2.sleep(100);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            m_T1 = System.currentTimeMillis();
            if (m_ErrorCount > 0) {
                Test2.fail("checksum sum failure in %d out %d messages", m_ErrorCount, N);
            }
            int cs = m_Port.getDataBits() + 2;
            double actual = (double)(m_TotalReceived * cs) * 1000.0 / (double)(m_T1 - m_T0);
            int requested = m_Port.getBaudRate();
            Test2.finishedOK("average speed %1.0f b/sec at baud rate %d", actual, requested);
        }
        finally {
            Test2.closePort();
        }
    }

    private static byte[] generateRandomMessage() {
        int n = 4 + (rnd.nextInt() & 0x3F);
        byte[] buffer = new byte[n + 2];
        int s = 0;
        for (int i = 0; i < n; ++i) {
            byte b;
            buffer[i] = b = (byte)(32 + (rnd.nextInt() & 0x3F));
            s += b;
        }
        buffer[i++] = (byte)(32 + (s & 0x3F));
        buffer[i++] = 10;
        return buffer;
    }

    private static void processBuffer(byte[] buffer, int n) {
        for (int i = 0; i < n; ++i) {
            int j;
            byte b = buffer[i];
            if (n > buffer.length) {
                ++m_ErrorCount;
                return;
            }
            Test2.m_ReceiveBuffer[Test2.m_BytesReceived++] = b;
            if (b != 10) continue;
            int s = 0;
            for (j = 0; j < m_BytesReceived - 2; ++j) {
                s += m_ReceiveBuffer[j];
            }
            byte cb = (byte)(32 + (s & 0x3F));
            if (cb != m_ReceiveBuffer[j] && m_RxCount > 0) {
                System.out.println("check sum failure");
                ++m_ErrorCount;
            }
            ++m_RxCount;
            m_BytesReceived = 0;
        }
    }

    static {
        rnd = new Random();
        m_ReceiveBuffer = new byte[10000];
        m_BytesReceived = 0;
        m_TxCount = 0;
        m_RxCount = 0;
        m_ErrorCount = 0;
        N = 1000;
    }
}

