/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.PureJavaSerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.testsuite.TestBase;

public class Test11
extends TestBase {
    static volatile boolean m_ThreadRunning;
    static volatile boolean m_ExitViaException;

    static void run() throws Exception {
        try {
            Test11.begin("Test11 - exit from blocking read/write ");
            Test11.openPort();
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            m_Port.disableReceiveTimeout();
            m_Port.disableReceiveThreshold();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    m_ThreadRunning = true;
                    byte[] rxbuffer = new byte[1];
                    try {
                        int n = TestBase.m_In.read(rxbuffer, 0, rxbuffer.length);
                    }
                    catch (Exception e) {
                        m_ExitViaException = true;
                    }
                    m_ThreadRunning = false;
                }
            });
            m_ThreadRunning = false;
            m_ExitViaException = false;
            thread.start();
            while (!m_ThreadRunning) {
                Thread.sleep(10L);
            }
            m_Port.close();
            m_Port = null;
            Thread.sleep(1000L);
            if (!m_ExitViaException) {
                Test11.fail("closing failed to interrupt a blocking read()", new Object[0]);
            }
            Test11.openPort();
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            m_Port.disableReceiveTimeout();
            m_Port.disableReceiveThreshold();
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] txbuffer = new byte[4096];
                    m_ThreadRunning = true;
                    try {
                        while (true) {
                            TestBase.m_Out.write(txbuffer, 0, txbuffer.length);
                        }
                    }
                    catch (Exception e) {
                        m_ExitViaException = true;
                        m_ThreadRunning = false;
                        return;
                    }
                }
            });
            m_ThreadRunning = false;
            m_ExitViaException = false;
            thread.start();
            while (!m_ThreadRunning) {
                Thread.sleep(10L);
            }
            m_Port.close();
            m_Port = null;
            Thread.sleep(10L);
            if (!m_ExitViaException) {
                Test11.fail("closing failed to interrupt a blocking write()", new Object[0]);
            }
            Thread.sleep(4000L);
            Test11.openPort();
            m_Port.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent event) {
                }
            });
            m_Port.notifyOnDataAvailable(true);
            m_Port.disableReceiveTimeout();
            m_Port.disableReceiveThreshold();
            m_Port.close();
            if (((PureJavaSerialPort)m_Port).isInternalThreadRunning()) {
                Test11.fail("internal thread failed to stop", new Object[0]);
            }
            m_Port = null;
            Test11.finishedOK();
        }
        finally {
            Test11.closePort();
        }
    }
}

