/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import purejavacomm.CommPortIdentifier;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;

public class PureJavaCommDemo {
    public static void main(String[] args) {
        try {
            System.out.println("PureJavaCommDemo");
            CommPortIdentifier portid = null;
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                portid = (CommPortIdentifier)e.nextElement();
                System.out.println("found " + portid.getName());
            }
            if (portid != null) {
                System.out.println("use " + portid.getName());
                SerialPort port = (SerialPort)portid.open("PureJavaCommDemo", 1000);
                port.notifyOnDataAvailable(true);
                port.notifyOnOutputEmpty(true);
                port.setFlowControlMode(12);
                final OutputStream outs = port.getOutputStream();
                final InputStream ins = port.getInputStream();
                boolean[] stop = new boolean[]{false};
                port.addEventListener(new SerialPortEventListener(){
                    byte[] linebuf = new byte[10000];
                    int inp = 0;
                    int okcnt = 0;
                    int errcnt = 0;
                    Random rnd = new Random();

                    public void serialEvent(SerialPortEvent event) {
                        try {
                            byte[] buffer;
                            int n;
                            if (event.getEventType() == 1) {
                                n = ins.available();
                                buffer = new byte[n];
                                n = ins.read(buffer, 0, n);
                                for (int i = 0; i < n; ++i) {
                                    int j;
                                    byte b = buffer[i];
                                    this.linebuf[this.inp++] = b;
                                    if (b != 10) continue;
                                    int s = 0;
                                    for (j = 0; j < this.inp - 2; ++j) {
                                        s += this.linebuf[j];
                                    }
                                    byte cb = (byte)(32 + (s & 0x3F));
                                    ++this.okcnt;
                                    if (cb != this.linebuf[j]) {
                                        System.out.println("check sum failure");
                                        ++this.errcnt;
                                    }
                                    System.out.println("msg " + this.inp + " ok " + this.okcnt + " err " + this.errcnt);
                                    this.inp = 0;
                                }
                            }
                            if (event.getEventType() == 2) {
                                n = 4 + (this.rnd.nextInt() & 0x3F);
                                buffer = new byte[n + 2];
                                int s = 0;
                                for (int i = 0; i < n; ++i) {
                                    byte b;
                                    buffer[i] = b = (byte)(32 + (this.rnd.nextInt() & 0x3F));
                                    s += b;
                                }
                                buffer[i++] = (byte)(32 + (s & 0x3F));
                                buffer[i++] = 10;
                                outs.write(buffer, 0, buffer.length);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                while (!stop[0]) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

