/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wildfly.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.wildfly.model.Employee;

@Path(value="/employees")
public class RestHighLevelClientEmployeeResource {
    @Inject
    private RestHighLevelClient client;

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getEmployeeById(@PathParam(value="id") Long id) throws IOException {
        Objects.requireNonNull(id);
        GetResponse response = this.client.get(new GetRequest("megacorp", Long.toString(id)), RequestOptions.DEFAULT);
        if (response.isExists()) {
            Map source = response.getSource();
            Employee employee = new Employee();
            employee.setFirstName((String)source.get("first_name"));
            employee.setLastName((String)source.get("last_name"));
            employee.setAge(((Integer)source.get("age")).intValue());
            employee.setAbout((String)source.get("about"));
            List interests = (List)source.get("interests");
            employee.setInterests(interests);
            return Response.ok((Object)employee).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response putEmployeeById(@PathParam(value="id") Long id, Employee employee) throws URISyntaxException, IOException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(employee);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field("first_name", employee.getFirstName());
            builder.field("last_name", employee.getLastName());
            builder.field("age", employee.getAge());
            builder.field("about", employee.getAbout());
            if (employee.getInterests() != null) {
                builder.startArray("interests");
                for (String interest : employee.getInterests()) {
                    builder.value(interest);
                }
                builder.endArray();
            }
            builder.endObject();
            IndexRequest request = new IndexRequest("megacorp");
            request.id(Long.toString(id));
            request.source(builder);
            IndexResponse response = this.client.index(request, RequestOptions.DEFAULT);
            if (response.status().getStatus() == 201) {
                Response response2 = Response.created((URI)new URI("/employees/" + id)).build();
                return response2;
            }
            Response response3 = Response.ok().build();
            return response3;
        }
    }
}

