/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Query;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.query.InternalProfileComponent;
import org.opensearch.search.profile.query.ProfileCollectorManager;
import org.opensearch.search.query.EarlyTerminatingCollector;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QueryCollectorManagerContext;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.query.TopDocsCollectorContext;

public class ConcurrentQueryPhaseSearcher
extends QueryPhase.DefaultQueryPhaseSearcher {
    private static final Logger LOGGER = LogManager.getLogger(ConcurrentQueryPhaseSearcher.class);

    protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        boolean couldUseConcurrentSegmentSearch = ConcurrentQueryPhaseSearcher.allowConcurrentSegmentSearch(searcher);
        if (searchContext.aggregations() != null) {
            couldUseConcurrentSegmentSearch = false;
            LOGGER.debug("Unable to use concurrent search over index segments (experimental): aggregations are present");
        }
        if (couldUseConcurrentSegmentSearch) {
            LOGGER.debug("Using concurrent search over index segments (experimental)");
            return ConcurrentQueryPhaseSearcher.searchWithCollectorManager(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
        }
        return super.searchWithCollector(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
    }

    private static boolean searchWithCollectorManager(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectorContexts, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        CollectorManager collectorManager;
        TopDocsCollectorContext topDocsFactory = TopDocsCollectorContext.createTopDocsCollectorContext((SearchContext)searchContext, (boolean)hasFilterCollector);
        collectorContexts.addFirst((QueryCollectorContext)topDocsFactory);
        QuerySearchResult queryResult = searchContext.queryResult();
        if (searchContext.aggregations() != null) {
            throw new UnsupportedOperationException("The concurrent segment search does not support aggregations yet");
        }
        if (searchContext.getProfilers() != null) {
            ProfileCollectorManager profileCollectorManager = QueryCollectorManagerContext.createQueryCollectorManagerWithProfiler(collectorContexts);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector((InternalProfileComponent)profileCollectorManager);
            collectorManager = profileCollectorManager;
        } else {
            collectorManager = QueryCollectorManagerContext.createMultiCollectorManager(collectorContexts);
        }
        try {
            ReduceableSearchResult result = (ReduceableSearchResult)searcher.search(query, collectorManager);
            result.reduce(queryResult);
        }
        catch (EarlyTerminatingCollector.EarlyTerminationException e) {
            queryResult.terminatedEarly(true);
        }
        catch (QueryPhase.TimeExceededException e) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        return topDocsFactory.shouldRescore();
    }

    private static boolean allowConcurrentSegmentSearch(ContextIndexSearcher searcher) {
        return searcher.getExecutor() != null;
    }
}

