/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.search.query.ConcurrentQueryPhaseSearcher;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;

public class ConcurrentSegmentSearchPlugin
extends Plugin
implements SearchPlugin {
    private static final String INDEX_SEARCHER = "index_searcher";

    public Optional<QueryPhaseSearcher> getQueryPhaseSearcher() {
        return Optional.of(new ConcurrentQueryPhaseSearcher());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        int allocatedProcessors = OpenSearchExecutors.allocatedProcessors((Settings)settings);
        return Collections.singletonList(new FixedExecutorBuilder(settings, INDEX_SEARCHER, allocatedProcessors, 1000, "thread_pool.index_searcher"));
    }

    public Optional<SearchPlugin.ExecutorServiceProvider> getIndexSearcherExecutorProvider() {
        return Optional.of(threadPool -> threadPool.executor(INDEX_SEARCHER));
    }
}

