/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.reactor.netty4;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpResponse;
import org.opensearch.transport.reactor.netty4.Netty4Utils;

class ReactorNetty4HttpResponse
extends DefaultFullHttpResponse
implements HttpResponse {
    private final HttpHeaders requestHeaders;

    ReactorNetty4HttpResponse(HttpHeaders requestHeaders, HttpVersion version, RestStatus status, BytesReference content) {
        super(version, HttpResponseStatus.valueOf((int)status.getStatus()), Netty4Utils.toByteBuf(content));
        this.requestHeaders = requestHeaders;
    }

    public void addHeader(String name, String value) {
        this.headers().add(name, (Object)value);
    }

    public boolean containsHeader(String name) {
        return this.headers().contains(name);
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders;
    }
}

