/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.reactor.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.reactor.netty4.NonStreamingHttpChannel;
import org.opensearch.http.reactor.netty4.ReactorNetty4HttpRequest;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

class NonStreamingRequestConsumer<T extends HttpContent>
implements Consumer<T>,
Publisher<HttpContent>,
Disposable {
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final CompositeByteBuf content;
    private final Publisher<HttpContent> publisher;
    private final AbstractHttpServerTransport transport;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private volatile FluxSink<HttpContent> emitter;

    NonStreamingRequestConsumer(AbstractHttpServerTransport transport, HttpServerRequest request, HttpServerResponse response, int maxCompositeBufferComponents) {
        this.transport = transport;
        this.request = request;
        this.response = response;
        this.content = response.alloc().compositeBuffer(maxCompositeBufferComponents);
        this.publisher = Flux.create(emitter -> this.register((FluxSink<HttpContent>)emitter));
    }

    private void register(FluxSink<HttpContent> emitter) {
        this.emitter = emitter.onDispose((Disposable)this).onCancel((Disposable)this);
    }

    @Override
    public void accept(T message) {
        try {
            if (message instanceof LastHttpContent) {
                this.process((HttpContent)message, this.emitter);
            } else if (message instanceof HttpContent) {
                this.process((HttpContent)message, this.emitter);
            }
        }
        catch (Throwable ex) {
            this.emitter.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpContent in, FluxSink<HttpContent> emitter) {
        this.content.addComponent(true, in.content().retain());
        if (in instanceof LastHttpContent) {
            NonStreamingHttpChannel channel = new NonStreamingHttpChannel(this.request, this.response, emitter);
            HttpRequest r = this.createRequest(this.request, this.content);
            try {
                this.transport.incomingRequest(r, (HttpChannel)channel);
            }
            catch (Exception ex) {
                emitter.error((Throwable)ex);
                this.transport.onException((HttpChannel)channel, ex);
            }
            finally {
                r.release();
                if (this.disposed.compareAndSet(false, true)) {
                    this.content.release();
                }
            }
        }
    }

    HttpRequest createRequest(HttpServerRequest request, CompositeByteBuf content) {
        return new ReactorNetty4HttpRequest(request, (ByteBuf)content.retain());
    }

    public void subscribe(Subscriber<? super HttpContent> s) {
        this.publisher.subscribe(s);
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.content.release();
        }
    }
}

