/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.reactor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.common.SetOnce;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.reactor.netty4.ReactorNetty4HttpServerTransport;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.reactor.SharedGroupFactory;

public class ReactorNetty4Plugin
extends Plugin
implements NetworkPlugin {
    public static final String REACTOR_NETTY_HTTP_TRANSPORT_NAME = "reactor-netty4";
    private final SetOnce<SharedGroupFactory> groupFactory = new SetOnce();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(new Setting[0]);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, Tracer tracer) {
        return Collections.singletonMap(REACTOR_NETTY_HTTP_TRANSPORT_NAME, () -> new ReactorNetty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), tracer));
    }

    private SharedGroupFactory getSharedGroupFactory(Settings settings) {
        SharedGroupFactory groupFactory = (SharedGroupFactory)this.groupFactory.get();
        if (groupFactory != null) {
            assert (groupFactory.getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return groupFactory;
        }
        this.groupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.groupFactory.get();
    }
}

