/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.reactor.netty4;

import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.time.Duration;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.util.net.NetUtils;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpReadTimeoutException;
import org.opensearch.http.HttpServerChannel;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.http.reactor.netty4.NonStreamingRequestConsumer;
import org.opensearch.http.reactor.netty4.ReactorNetty4HttpServerChannel;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.reactor.SharedGroupFactory;
import org.opensearch.transport.reactor.netty4.Netty4Utils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.DisposableServer;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class ReactorNetty4HttpServerTransport
extends AbstractHttpServerTransport {
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    private static final ByteSizeValue MTU = new ByteSizeValue(Long.parseLong(System.getProperty("opensearch.net.mtu", "1500")));
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = Setting.intSetting((String)"http.netty.worker_count", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt((String)s, (int)2, (int)Integer.MAX_VALUE, (String)SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), new Setting.Property[]{Setting.Property.NodeScope});
    private final SharedGroupFactory sharedGroupFactory;
    private final int readTimeoutMillis;
    private final int connectTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private final ByteSizeValue maxInitialLineLength;
    private final ByteSizeValue maxHeaderSize;
    private final ByteSizeValue maxChunkSize;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    private volatile DisposableServer disposableServer;
    private volatile Scheduler scheduler;

    public ReactorNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, tracer);
        Netty4Utils.setAvailableProcessors((Integer)OpenSearchExecutors.NODE_PROCESSORS_SETTING.get(settings));
        this.readTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings)).getMillis());
        this.connectTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_CONNECT_TIMEOUT.get(settings)).getMillis());
        this.sharedGroupFactory = sharedGroupFactory;
        this.maxCompositeBufferComponents = (Integer)SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        HttpServer server = this.configureChannelOptions(((HttpServer)HttpServer.create().httpFormDecoder(builder -> builder.scheduler(this.scheduler)).idleTimeout(Duration.ofMillis(this.connectTimeoutMillis)).readTimeout(Duration.ofMillis(this.readTimeoutMillis)).runOn(this.sharedGroup.getLowLevelGroup())).bindAddress(() -> socketAddress).compress(true).httpRequestDecoder(spec -> (HttpRequestDecoderSpec)((HttpRequestDecoderSpec)((HttpRequestDecoderSpec)spec.maxChunkSize(this.maxChunkSize.bytesAsInt())).maxHeaderSize(this.maxHeaderSize.bytesAsInt())).maxInitialLineLength(this.maxInitialLineLength.bytesAsInt())).protocol(new HttpProtocol[]{HttpProtocol.HTTP11, HttpProtocol.H2C}).handle((req, res) -> this.incomingRequest((HttpServerRequest)req, (HttpServerResponse)res)));
        this.disposableServer = server.bindNow();
        return new ReactorNetty4HttpServerChannel(this.disposableServer.channel());
    }

    private HttpServer configureChannelOptions(HttpServer server1) {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        HttpServer configured = (HttpServer)((HttpServer)server1.childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings)))).childOption(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)));
        if (((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
            SocketOption keepCountOption;
            SocketOption keepIntervalOption;
            SocketOption keepIdleOption;
            if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                configured = (HttpServer)configured.childOption(NioChannelOption.of((SocketOption)keepIdleOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings)));
            }
            if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                configured = (HttpServer)configured.childOption(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings)));
            }
            if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                configured = (HttpServer)configured.childOption(NioChannelOption.of((SocketOption)keepCountOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings)));
            }
        }
        if ((tcpSendBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            configured = (HttpServer)configured.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            configured = (HttpServer)configured.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        boolean reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
        configured = (HttpServer)configured.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        configured = (HttpServer)configured.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        return configured;
    }

    protected Publisher<Void> incomingRequest(HttpServerRequest request, HttpServerResponse response) {
        NonStreamingRequestConsumer consumer = new NonStreamingRequestConsumer(this, request, response, this.maxCompositeBufferComponents);
        request.receiveContent().switchIfEmpty((Publisher)Mono.just((Object)DefaultLastHttpContent.EMPTY_LAST_CONTENT)).subscribe(consumer);
        return Mono.from(consumer).flatMap(hc -> {
            FullHttpResponse r = (FullHttpResponse)hc;
            response.status(r.status());
            response.trailerHeaders(c -> r.trailingHeaders().forEach(h -> c.add((String)h.getKey(), h.getValue())));
            response.chunkedTransfer(false);
            response.compression(true);
            r.headers().forEach(h -> response.addHeader((CharSequence)h.getKey(), (CharSequence)h.getValue()));
            return Mono.from((Publisher)response.sendObject((Object)r.content()));
        });
    }

    protected void stopInternal() {
        if (this.sharedGroup != null) {
            this.sharedGroup.shutdown();
            this.sharedGroup = null;
        }
        if (this.scheduler != null) {
            this.scheduler.dispose();
            this.scheduler = null;
        }
        if (this.disposableServer != null) {
            this.disposableServer.disposeNow();
            this.disposableServer = null;
        }
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.scheduler = Schedulers.newBoundedElastic((int)Schedulers.DEFAULT_BOUNDED_ELASTIC_SIZE, (int)Schedulers.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"http-form-decoder");
            this.sharedGroup = this.sharedGroupFactory.getHttpGroup();
            this.bindServer();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    public void onException(HttpChannel channel, Exception cause) {
        if (cause instanceof ReadTimeoutException) {
            super.onException(channel, (Exception)new HttpReadTimeoutException((long)this.readTimeoutMillis, cause));
        } else {
            super.onException(channel, cause);
        }
    }
}

