/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.reactor.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.reactor.netty4.HttpConversionUtil;
import org.opensearch.http.reactor.netty4.ReactorNetty4HttpResponse;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.reactor.netty4.Netty4Utils;
import reactor.netty.http.server.HttpServerRequest;

class ReactorNetty4HttpRequest
implements HttpRequest {
    private final String protocol;
    private final HttpMethod method;
    private final String uri;
    private final ByteBuf content;
    private final HttpHeadersMap headers;
    private final AtomicBoolean released;
    private final Exception inboundException;
    private final boolean pooled;

    ReactorNetty4HttpRequest(HttpServerRequest request, ByteBuf content) {
        this(request, new HttpHeadersMap(request.requestHeaders()), new AtomicBoolean(false), true, content);
    }

    ReactorNetty4HttpRequest(HttpServerRequest request, ByteBuf content, Exception inboundException) {
        this(request.protocol(), request.method(), request.uri(), new HttpHeadersMap(request.requestHeaders()), new AtomicBoolean(false), true, content, inboundException);
    }

    private ReactorNetty4HttpRequest(HttpServerRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, ByteBuf content) {
        this(request.protocol(), request.method(), request.uri(), headers, released, pooled, content, null);
    }

    private ReactorNetty4HttpRequest(String protocol, HttpMethod method, String uri, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, ByteBuf content, Exception inboundException) {
        this.protocol = protocol;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.content = content;
        this.pooled = pooled;
        this.released = released;
        this.inboundException = inboundException;
    }

    public RestRequest.Method method() {
        return HttpConversionUtil.convertMethod(this.method);
    }

    public String uri() {
        return this.uri;
    }

    public BytesReference content() {
        assert (!this.released.get());
        return Netty4Utils.toBytesReference(this.content);
    }

    public void release() {
        if (this.pooled && this.released.compareAndSet(false, true)) {
            this.content.release();
        }
    }

    public HttpRequest releaseAndCopy() {
        assert (!this.released.get());
        if (!this.pooled) {
            return this;
        }
        try {
            ByteBuf copiedContent = Unpooled.copiedBuffer((ByteBuf)this.content);
            ReactorNetty4HttpRequest reactorNetty4HttpRequest = new ReactorNetty4HttpRequest(this.protocol, this.method, this.uri, this.headers, new AtomicBoolean(false), false, copiedContent, null);
            return reactorNetty4HttpRequest;
        }
        finally {
            this.release();
        }
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> strictCookies() {
        Set cookies;
        String cookieString = this.headers.httpHeaders.get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            return ServerCookieEncoder.STRICT.encode((Collection)cookies);
        }
        return Collections.emptyList();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        if (this.protocol.equals(HttpVersion.HTTP_1_0.toString())) {
            return HttpRequest.HttpVersion.HTTP_1_0;
        }
        if (this.protocol.equals(HttpVersion.HTTP_1_1.toString())) {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }
        throw new IllegalArgumentException("Unexpected http protocol version: " + this.protocol);
    }

    public HttpRequest removeHeader(String header) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        headersWithoutContentTypeHeader.add(this.headers.httpHeaders);
        headersWithoutContentTypeHeader.remove(header);
        return new ReactorNetty4HttpRequest(this.protocol, this.method, this.uri, new HttpHeadersMap((HttpHeaders)headersWithoutContentTypeHeader), this.released, this.pooled, this.content, null);
    }

    public ReactorNetty4HttpResponse createResponse(RestStatus status, BytesReference content) {
        return new ReactorNetty4HttpResponse(this.headers.httpHeaders, HttpVersion.valueOf((String)this.protocol), status, content);
    }

    public Exception getInboundException() {
        return this.inboundException;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(arg_0 -> ((HttpHeaders)this.httpHeaders).getAll(arg_0)).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll(k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List>((String)k, this.httpHeaders.getAll(k))).collect(Collectors.toSet());
        }
    }
}

