/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.reactor.netty4;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.common.concurrent.CompletableContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpResponse;
import org.opensearch.transport.reactor.netty4.Netty4Utils;
import reactor.core.publisher.FluxSink;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

class NonStreamingHttpChannel
implements HttpChannel {
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final FluxSink<HttpContent> emitter;

    NonStreamingHttpChannel(HttpServerRequest request, HttpServerResponse response, FluxSink<HttpContent> emitter) {
        this.request = request;
        this.response = response;
        this.emitter = emitter;
        this.request.withConnection(connection -> Netty4Utils.addListener(connection.channel().closeFuture(), this.closeContext));
    }

    public boolean isOpen() {
        AtomicBoolean isOpen = new AtomicBoolean();
        this.request.withConnection(connection -> isOpen.set(connection.channel().isOpen()));
        return isOpen.get();
    }

    public void close() {
        this.request.withConnection(connection -> connection.channel().close());
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.emitter.next((Object)this.createResponse(response));
        listener.onResponse(null);
        this.emitter.complete();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.response.remoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.response.hostAddress();
    }

    FullHttpResponse createResponse(HttpResponse response) {
        return (FullHttpResponse)response;
    }
}

