/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.systemd;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.opensearch.Build;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.script.ScriptService;
import org.opensearch.systemd.Libsystemd;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class SystemdPlugin
extends Plugin
implements ClusterPlugin {
    private static final Logger logger = LogManager.getLogger(SystemdPlugin.class);
    private final boolean enabled;
    private final SetOnce<Scheduler.Cancellable> extender = new SetOnce();

    final boolean isEnabled() {
        return this.enabled;
    }

    public SystemdPlugin() {
        this(true, Build.CURRENT.type(), System.getenv("OPENSEARCH_SD_NOTIFY"));
    }

    SystemdPlugin(boolean assertIsPackageDistribution, Build.Type buildType, String esSDNotify) {
        boolean isPackageDistribution;
        boolean bl = isPackageDistribution = buildType == Build.Type.DEB || buildType == Build.Type.RPM;
        if (assertIsPackageDistribution) assert (isPackageDistribution) : buildType;
        if (!isPackageDistribution) {
            logger.debug("disabling sd_notify as the build type [{}] is not a package distribution", (Object)buildType);
            this.enabled = false;
            return;
        }
        logger.trace("OPENSEARCH_SD_NOTIFY is set to [{}]", (Object)esSDNotify);
        if (esSDNotify == null) {
            this.enabled = false;
            return;
        }
        if (!Boolean.TRUE.toString().equals(esSDNotify) && !Boolean.FALSE.toString().equals(esSDNotify)) {
            throw new RuntimeException("OPENSEARCH_SD_NOTIFY set to unexpected value [" + esSDNotify + "]");
        }
        this.enabled = Boolean.TRUE.toString().equals(esSDNotify);
    }

    Scheduler.Cancellable extender() {
        return (Scheduler.Cancellable)this.extender.get();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        if (!this.enabled) {
            this.extender.set(null);
            return Collections.emptyList();
        }
        this.extender.set((Object)threadPool.scheduleWithFixedDelay(() -> {
            int rc = this.sd_notify(0, "EXTEND_TIMEOUT_USEC=30000000");
            if (rc < 0) {
                logger.warn("extending startup timeout via sd_notify failed with [{}]", (Object)rc);
            }
        }, TimeValue.timeValueSeconds((long)15L), "same"));
        return Collections.emptyList();
    }

    int sd_notify(int unset_environment, String state) {
        int rc = Libsystemd.sd_notify(unset_environment, state);
        logger.trace("sd_notify({}, {}) returned [{}]", (Object)unset_environment, (Object)state, (Object)rc);
        return rc;
    }

    public void onNodeStarted() {
        if (!this.enabled) {
            assert (this.extender.get() == null);
            return;
        }
        int rc = this.sd_notify(0, "READY=1");
        if (rc < 0) {
            throw new RuntimeException("sd_notify returned error [" + rc + "]");
        }
        assert (this.extender.get() != null);
        boolean cancelled = ((Scheduler.Cancellable)this.extender.get()).cancel();
        assert (cancelled);
    }

    public void close() {
        if (!this.enabled) {
            return;
        }
        int rc = this.sd_notify(0, "STOPPING=1");
        if (rc < 0) {
            logger.warn("sd_notify returned error [{}]", (Object)rc);
        }
    }
}

