/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.gcs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.opensearch.repositories.gcs.GoogleCloudStorageRepository;
import org.opensearch.repositories.gcs.GoogleCloudStorageService;

public class GoogleCloudStoragePlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    final GoogleCloudStorageService storageService = this.createStorageService();

    public GoogleCloudStoragePlugin(Settings settings) {
        this.reload(settings);
    }

    protected GoogleCloudStorageService createStorageService() {
        return new GoogleCloudStorageService();
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("gcs", metadata -> new GoogleCloudStorageRepository(metadata, namedXContentRegistry, this.storageService, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(GoogleCloudStorageClientSettings.CREDENTIALS_FILE_SETTING, GoogleCloudStorageClientSettings.ENDPOINT_SETTING, GoogleCloudStorageClientSettings.PROJECT_ID_SETTING, GoogleCloudStorageClientSettings.CONNECT_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.READ_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.APPLICATION_NAME_SETTING, GoogleCloudStorageClientSettings.TOKEN_URI_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, GoogleCloudStorageClientSettings> clientsSettings = GoogleCloudStorageClientSettings.load(settings);
        this.storageService.refreshAndClearCache(clientsSettings);
    }
}

