/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.gcs;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.repositories.gcs.GoogleCloudStorageOperationsStats;

final class GoogleCloudStorageHttpStatsCollector
implements HttpResponseInterceptor {
    private static final List<Function<String, HttpRequestTracker>> trackerFactories = org.opensearch.common.collect.List.of((Object[])new Function[]{bucket -> HttpRequestTracker.access$100(String.format(Locale.ROOT, "/download/storage/v1/b/%s/o/.+", bucket), GoogleCloudStorageOperationsStats::trackGetOperation), bucket -> HttpRequestTracker.access$100(String.format(Locale.ROOT, "/storage/v1/b/%s/o/.+", bucket), GoogleCloudStorageOperationsStats::trackGetOperation), bucket -> HttpRequestTracker.access$100(String.format(Locale.ROOT, "/storage/v1/b/%s/o", bucket), GoogleCloudStorageOperationsStats::trackListOperation)});
    private final GoogleCloudStorageOperationsStats gcsOperationStats;
    private final List<HttpRequestTracker> trackers;

    GoogleCloudStorageHttpStatsCollector(GoogleCloudStorageOperationsStats gcsOperationStats) {
        this.gcsOperationStats = gcsOperationStats;
        this.trackers = trackerFactories.stream().map(trackerFactory -> (HttpRequestTracker)trackerFactory.apply(gcsOperationStats.getTrackedBucket())).collect(Collectors.toList());
    }

    public void interceptResponse(HttpResponse response) {
        if (!response.isSuccessStatusCode()) {
            return;
        }
        HttpRequest request = response.getRequest();
        for (HttpRequestTracker tracker : this.trackers) {
            if (!tracker.track(request, this.gcsOperationStats)) continue;
            return;
        }
    }

    private static final class HttpRequestTracker {
        private final String method;
        private final Pattern pathPattern;
        private final Consumer<GoogleCloudStorageOperationsStats> statsTracker;

        private HttpRequestTracker(String method, String pathPattern, Consumer<GoogleCloudStorageOperationsStats> statsTracker) {
            this.method = method;
            this.pathPattern = Pattern.compile(pathPattern);
            this.statsTracker = statsTracker;
        }

        private static HttpRequestTracker get(String pathPattern, Consumer<GoogleCloudStorageOperationsStats> statsConsumer) {
            return new HttpRequestTracker("GET", pathPattern, statsConsumer);
        }

        private boolean track(HttpRequest httpRequest, GoogleCloudStorageOperationsStats stats) {
            if (!this.matchesCriteria(httpRequest)) {
                return false;
            }
            this.statsTracker.accept(stats);
            return true;
        }

        private boolean matchesCriteria(HttpRequest httpRequest) {
            return this.method.equalsIgnoreCase(httpRequest.getRequestMethod()) && this.pathMatches(httpRequest.getUrl());
        }

        private boolean pathMatches(GenericUrl url) {
            return this.pathPattern.matcher(url.getRawPath()).matches();
        }
    }
}

