/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.repositories.azure.AzureStorageSettings;
import org.opensearch.repositories.azure.LocationMode;
import org.opensearch.repositories.azure.ProxySettings;
import org.opensearch.repositories.azure.SocketAccess;
import reactor.core.publisher.Mono;

public class AzureStorageService
implements AutoCloseable {
    private final ClientLogger logger = new ClientLogger(AzureStorageService.class);
    public static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    public static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(0xFA000000L, ByteSizeUnit.BYTES);
    volatile Map<String, AzureStorageSettings> storageSettings = Collections.emptyMap();
    private final Map<AzureStorageSettings, ClientState> clients = new ConcurrentHashMap<AzureStorageSettings, ClientState>();

    public AzureStorageService(Settings settings) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settings);
        this.refreshAndClearCache(clientsSettings);
    }

    public Tuple<BlobServiceClient, Supplier<Context>> client(String clientName) {
        return this.client(clientName, (request, response) -> {});
    }

    public Tuple<BlobServiceClient, Supplier<Context>> client(String clientName, BiConsumer<HttpRequest, HttpResponse> statsCollector) {
        AzureStorageSettings azureStorageSettings = this.storageSettings.get(clientName);
        if (azureStorageSettings == null) {
            throw new SettingsException("Unable to find client with name [" + clientName + "]");
        }
        ClientState state = this.clients.get(azureStorageSettings);
        if (state == null) {
            state = this.clients.computeIfAbsent(azureStorageSettings, key -> {
                try {
                    return this.buildClient(azureStorageSettings, statsCollector);
                }
                catch (IllegalArgumentException | URISyntaxException | InvalidKeyException e) {
                    throw new SettingsException("Invalid azure client settings with name [" + clientName + "]", (Throwable)e);
                }
            });
        }
        return new Tuple((Object)state.getClient(), () -> AzureStorageService.buildOperationContext(azureStorageSettings));
    }

    private ClientState buildClient(AzureStorageSettings azureStorageSettings, BiConsumer<HttpRequest, HttpResponse> statsCollector) throws InvalidKeyException, URISyntaxException {
        TimeValue responseTimeout;
        TimeValue readTimeout;
        TimeValue writeTimeout;
        BlobServiceClientBuilder builder = AzureStorageService.createClientBuilder(azureStorageSettings);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup((ThreadFactory)new NioThreadFactory());
        NettyAsyncHttpClientBuilder clientBuilder = new NettyAsyncHttpClientBuilder().eventLoopGroup((EventLoopGroup)eventLoopGroup);
        SocketAccess.doPrivilegedVoidException(() -> {
            final ProxySettings proxySettings = azureStorageSettings.getProxySettings();
            if (proxySettings != ProxySettings.NO_PROXY_SETTINGS) {
                if (proxySettings.isAuthenticated()) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(proxySettings.getUsername(), proxySettings.getPassword().toCharArray());
                        }
                    });
                }
                clientBuilder.proxy(new ProxyOptions(proxySettings.getType().toProxyType(), proxySettings.getAddress()));
            }
        });
        TimeValue connectTimeout = azureStorageSettings.getConnectTimeout();
        if (connectTimeout != null) {
            clientBuilder.connectTimeout(Duration.ofMillis(connectTimeout.millis()));
        }
        if ((writeTimeout = azureStorageSettings.getWriteTimeout()) != null) {
            clientBuilder.writeTimeout(Duration.ofMillis(writeTimeout.millis()));
        }
        if ((readTimeout = azureStorageSettings.getReadTimeout()) != null) {
            clientBuilder.readTimeout(Duration.ofMillis(readTimeout.millis()));
        }
        if ((responseTimeout = azureStorageSettings.getResponseTimeout()) != null) {
            clientBuilder.responseTimeout(Duration.ofMillis(responseTimeout.millis()));
        }
        builder.httpClient(clientBuilder.build());
        return new ClientState(this.applyLocationMode(builder, azureStorageSettings).addPolicy((HttpPipelinePolicy)new HttpStatsPolicy(statsCollector)).buildClient(), (EventLoopGroup)eventLoopGroup);
    }

    private BlobServiceClientBuilder applyLocationMode(BlobServiceClientBuilder builder, AzureStorageSettings settings) {
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)settings.getConnectString(), (ClientLogger)this.logger);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw new IllegalArgumentException("connectionString missing required settings to derive blob service primary endpoint.");
        }
        LocationMode locationMode = settings.getLocationMode();
        if (locationMode == LocationMode.PRIMARY_ONLY) {
            builder.retryOptions(this.createRetryPolicy(settings, null));
        } else if (locationMode == LocationMode.SECONDARY_ONLY) {
            if (endpoint.getSecondaryUri() == null) {
                throw new IllegalArgumentException("connectionString missing required settings to derive blob service secondary endpoint.");
            }
            builder.endpoint(endpoint.getSecondaryUri()).retryOptions(this.createRetryPolicy(settings, null));
        } else if (locationMode == LocationMode.PRIMARY_THEN_SECONDARY) {
            builder.retryOptions(this.createRetryPolicy(settings, endpoint.getSecondaryUri()));
        } else if (locationMode == LocationMode.SECONDARY_THEN_PRIMARY) {
            if (endpoint.getSecondaryUri() == null) {
                throw new IllegalArgumentException("connectionString missing required settings to derive blob service secondary endpoint.");
            }
            builder.endpoint(endpoint.getSecondaryUri()).retryOptions(this.createRetryPolicy(settings, endpoint.getPrimaryUri()));
        } else {
            throw new IllegalArgumentException("Unsupported location mode: " + (Object)((Object)locationMode));
        }
        return builder;
    }

    private static BlobServiceClientBuilder createClientBuilder(AzureStorageSettings settings) throws InvalidKeyException, URISyntaxException {
        return new BlobServiceClientBuilder().connectionString(settings.getConnectString());
    }

    private static Context buildOperationContext(AzureStorageSettings azureStorageSettings) {
        return Context.NONE;
    }

    RequestRetryOptions createRetryPolicy(AzureStorageSettings azureStorageSettings, String secondaryHost) {
        return new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, Integer.valueOf(azureStorageSettings.getMaxRetries()), (Integer)null, null, null, secondaryHost);
    }

    public Map<String, AzureStorageSettings> refreshAndClearCache(Map<String, AzureStorageSettings> clientsSettings) {
        Map<String, AzureStorageSettings> prevSettings = this.storageSettings;
        HashMap<AzureStorageSettings, ClientState> prevClients = new HashMap<AzureStorageSettings, ClientState>(this.clients);
        prevClients.values().forEach(this::closeInternally);
        prevClients.clear();
        this.storageSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        this.clients.clear();
        return prevSettings;
    }

    @Override
    public void close() {
        this.clients.values().forEach(this::closeInternally);
        this.clients.clear();
    }

    public Duration getBlobRequestTimeout(String clientName) {
        AzureStorageSettings azureStorageSettings = this.storageSettings.get(clientName);
        if (azureStorageSettings == null) {
            throw new SettingsException("Unable to find client with name [" + clientName + "]");
        }
        long timeout = azureStorageSettings.getTimeout().getMillis();
        if (timeout > 0L) {
            if (timeout > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout [" + azureStorageSettings.getTimeout() + "] exceeds 2,147,483,647ms.");
            }
            return Duration.ofMillis(timeout);
        }
        return null;
    }

    ParallelTransferOptions getBlobRequestOptionsForWriteBlob() {
        return null;
    }

    private void closeInternally(ClientState state) {
        Future shutdownFuture = state.getEventLoopGroup().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        shutdownFuture.awaitUninterruptibly();
        if (!shutdownFuture.isSuccess()) {
            this.logger.warning("Error closing Netty Event Loop group", new Object[]{shutdownFuture.cause()});
        }
    }

    static {
        Configuration.getGlobalConfiguration().put("AZURE_JACKSON_ADAPTER_USE_ACCESS_HELPER", "true");
    }

    private static class NioThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NioThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "reactor-nio-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class ClientState {
        private final BlobServiceClient client;
        private final EventLoopGroup eventLoopGroup;

        ClientState(BlobServiceClient client, EventLoopGroup eventLoopGroup) {
            this.client = client;
            this.eventLoopGroup = eventLoopGroup;
        }

        public BlobServiceClient getClient() {
            return this.client;
        }

        public EventLoopGroup getEventLoopGroup() {
            return this.eventLoopGroup;
        }
    }

    private static class HttpStatsPolicy
    implements HttpPipelinePolicy {
        private final BiConsumer<HttpRequest, HttpResponse> statsCollector;

        HttpStatsPolicy(BiConsumer<HttpRequest, HttpResponse> statsCollector) {
            this.statsCollector = statsCollector;
        }

        public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
            HttpRequest request = httpPipelineCallContext.getHttpRequest();
            return httpPipelineNextPolicy.process().doOnNext(response -> this.statsCollector.accept(request, (HttpResponse)response));
        }

        public HttpPipelinePosition getPipelinePosition() {
            return HttpPipelinePosition.PER_RETRY;
        }
    }
}

