/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.List;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.AutoCreateIndex;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.RemoteInfo;
import org.opensearch.index.reindex.TransportReindexAction;
import org.opensearch.search.builder.SearchSourceBuilder;

class ReindexValidator {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ReindexValidator.class);
    static final String SORT_DEPRECATED_MESSAGE = "The sort option in reindex is deprecated. Instead consider using query filtering to find the desired subset of data.";
    private final CharacterRunAutomaton remoteWhitelist;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final AutoCreateIndex autoCreateIndex;

    ReindexValidator(Settings settings, ClusterService clusterService, IndexNameExpressionResolver resolver, AutoCreateIndex autoCreateIndex) {
        this.remoteWhitelist = ReindexValidator.buildRemoteWhitelist((List)TransportReindexAction.REMOTE_CLUSTER_WHITELIST.get(settings));
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.autoCreateIndex = autoCreateIndex;
    }

    void initialValidation(ReindexRequest request) {
        ReindexValidator.checkRemoteWhitelist(this.remoteWhitelist, request.getRemoteInfo());
        ClusterState state = this.clusterService.state();
        ReindexValidator.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.resolver, this.autoCreateIndex, state);
        SearchSourceBuilder searchSource = request.getSearchRequest().source();
        if (searchSource != null && searchSource.sorts() != null && !searchSource.sorts().isEmpty()) {
            deprecationLogger.deprecate("reindex_sort", SORT_DEPRECATED_MESSAGE, new Object[0]);
        }
    }

    static void checkRemoteWhitelist(CharacterRunAutomaton whitelist, RemoteInfo remoteInfo) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ':' + remoteInfo.getPort();
        if (whitelist.run(check)) {
            return;
        }
        String whiteListKey = TransportReindexAction.REMOTE_CLUSTER_WHITELIST.getKey();
        throw new IllegalArgumentException('[' + check + "] not whitelisted in " + whiteListKey);
    }

    static CharacterRunAutomaton buildRemoteWhitelist(List<String> whitelist) {
        if (whitelist.isEmpty()) {
            return new CharacterRunAutomaton(Automata.makeEmpty());
        }
        Automaton automaton = Regex.simpleMatchToAutomaton((String[])whitelist.toArray(Strings.EMPTY_ARRAY));
        if (Operations.isTotal((Automaton)(automaton = MinimizationOperations.minimize((Automaton)automaton, (int)10000)))) {
            throw new IllegalArgumentException("Refusing to start because whitelist " + whitelist + " accepts all addresses. This would allow users to reindex-from-remote any URL they like effectively having OpenSearch make HTTP GETs for them.");
        }
        return new CharacterRunAutomaton(automaton);
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (destination.isRequireAlias() && !clusterState.getMetadata().hasAlias(target)) {
            throw new IndexNotFoundException("[require_alias] request flag is [true] and [" + target + "] is not an alias", target);
        }
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteWriteIndex(clusterState, (IndicesRequest)destination).getName();
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + ']');
            throw e;
        }
    }
}

