/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.transport.top_queries;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueries;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesRequest;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesResponse;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportTopQueriesAction
extends TransportNodesAction<TopQueriesRequest, TopQueriesResponse, NodeRequest, TopQueries> {
    private final QueryInsightsService queryInsightsService;

    @Inject
    public TransportTopQueriesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, QueryInsightsService queryInsightsService, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/insights/top_queries", threadPool, clusterService, transportService, actionFilters, TopQueriesRequest::new, NodeRequest::new, "generic", TopQueries.class);
        this.queryInsightsService = queryInsightsService;
    }

    protected TopQueriesResponse newResponse(TopQueriesRequest topQueriesRequest, List<TopQueries> responses, List<FailedNodeException> failures) {
        if (topQueriesRequest.getMetricType() == MetricType.LATENCY) {
            return new TopQueriesResponse(this.clusterService.getClusterName(), responses, failures, (Integer)this.clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_SIZE), MetricType.LATENCY);
        }
        throw new OpenSearchException(String.format(Locale.ROOT, "invalid metric type %s", topQueriesRequest.getMetricType()), new Object[0]);
    }

    protected NodeRequest newNodeRequest(TopQueriesRequest request) {
        return new NodeRequest(request);
    }

    protected TopQueries newNodeResponse(StreamInput in) throws IOException {
        return new TopQueries(in);
    }

    protected TopQueries nodeOperation(NodeRequest nodeRequest) {
        TopQueriesRequest request = nodeRequest.request;
        if (request.getMetricType() == MetricType.LATENCY) {
            return new TopQueries(this.clusterService.localNode(), this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).getTopQueriesRecords(true));
        }
        throw new OpenSearchException(String.format(Locale.ROOT, "invalid metric type %s", request.getMetricType()), new Object[0]);
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        final TopQueriesRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new TopQueriesRequest(in);
        }

        public NodeRequest(TopQueriesRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

