/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.MetricType;

public class SearchQueryRecord
implements ToXContentObject,
Writeable {
    private final long timestamp;
    private final Map<MetricType, Number> measurements;
    private final Map<Attribute, Object> attributes;

    public SearchQueryRecord(StreamInput in) throws IOException, ClassCastException {
        this.timestamp = in.readLong();
        this.measurements = new HashMap<MetricType, Number>();
        in.readMap(MetricType::readFromStream, StreamInput::readGenericValue).forEach((metricType, o) -> this.measurements.put((MetricType)metricType, metricType.parseValue(o)));
        this.attributes = in.readMap(Attribute::readFromStream, StreamInput::readGenericValue);
    }

    public SearchQueryRecord(long timestamp, Map<MetricType, Number> measurements, Map<Attribute, Object> attributes) {
        if (measurements == null) {
            throw new IllegalArgumentException("Measurements cannot be null");
        }
        this.measurements = measurements;
        this.attributes = attributes;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Number getMeasurement(MetricType name) {
        return this.measurements.get(name);
    }

    public Map<MetricType, Number> getMeasurements() {
        return this.measurements;
    }

    public Map<Attribute, Object> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("timestamp", this.timestamp);
        for (Map.Entry<Attribute, Object> entry : this.attributes.entrySet()) {
            builder.field(entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Enum, Object> entry : this.measurements.entrySet()) {
            builder.field(((MetricType)entry.getKey()).toString(), entry.getValue());
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeMap(this.measurements, (stream, metricType) -> MetricType.writeTo(out, metricType), StreamOutput::writeGenericValue);
        out.writeMap(this.attributes, (stream, attribute) -> Attribute.writeTo(out, attribute), StreamOutput::writeGenericValue);
    }

    public static int compare(SearchQueryRecord a, SearchQueryRecord b, MetricType metricType) {
        return metricType.compare(a.getMeasurement(metricType), b.getMeasurement(metricType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchQueryRecord)) {
            return false;
        }
        SearchQueryRecord other = (SearchQueryRecord)o;
        return this.timestamp == other.getTimestamp() && this.measurements.equals(other.getMeasurements()) && this.attributes.size() == other.getAttributes().size();
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.measurements, this.attributes);
    }
}

