/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.plugin.insights.core.service.TopQueriesService;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class QueryInsightsService
extends AbstractLifecycleComponent {
    private final ThreadPool threadPool;
    private final Map<MetricType, TopQueriesService> topQueriesServices;
    private final Map<MetricType, Boolean> enableCollect = new HashMap<MetricType, Boolean>();
    private final LinkedBlockingQueue<SearchQueryRecord> queryRecordsQueue = new LinkedBlockingQueue(1000);
    protected volatile Scheduler.Cancellable scheduledFuture;

    @Inject
    public QueryInsightsService(ThreadPool threadPool) {
        this.topQueriesServices = new HashMap<MetricType, TopQueriesService>();
        for (MetricType metricType : MetricType.allMetricTypes()) {
            this.enableCollect.put(metricType, false);
            this.topQueriesServices.put(metricType, new TopQueriesService(metricType));
        }
        this.threadPool = threadPool;
    }

    public boolean addRecord(SearchQueryRecord record) {
        boolean shouldAdd = false;
        for (Map.Entry<MetricType, TopQueriesService> entry : this.topQueriesServices.entrySet()) {
            List<SearchQueryRecord> currentSnapshot;
            if (!this.enableCollect.get(entry.getKey()).booleanValue() || (currentSnapshot = entry.getValue().getTopQueriesCurrentSnapshot()).size() >= entry.getValue().getTopNSize() && SearchQueryRecord.compare(record, currentSnapshot.get(0), entry.getKey()) <= 0) continue;
            shouldAdd = true;
            break;
        }
        if (shouldAdd) {
            return this.queryRecordsQueue.offer(record);
        }
        return false;
    }

    public void drainRecords() {
        ArrayList<SearchQueryRecord> records = new ArrayList<SearchQueryRecord>();
        this.queryRecordsQueue.drainTo(records);
        records.sort(Comparator.comparingLong(SearchQueryRecord::getTimestamp));
        for (MetricType metricType : MetricType.allMetricTypes()) {
            if (!this.enableCollect.get(metricType).booleanValue()) continue;
            this.topQueriesServices.get(metricType).consumeRecords(records);
        }
    }

    public TopQueriesService getTopQueriesService(MetricType metricType) {
        return this.topQueriesServices.get(metricType);
    }

    public void enableCollection(MetricType metricType, boolean enable) {
        this.enableCollect.put(metricType, enable);
        this.topQueriesServices.get(metricType).setEnabled(enable);
    }

    public boolean isCollectionEnabled(MetricType metricType) {
        return this.enableCollect.get(metricType);
    }

    public boolean isEnabled() {
        for (MetricType t : MetricType.allMetricTypes()) {
            if (!this.isCollectionEnabled(t)) continue;
            return true;
        }
        return false;
    }

    protected void doStart() {
        if (this.isEnabled()) {
            this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(this::drainRecords, QueryInsightsSettings.QUERY_RECORD_QUEUE_DRAIN_INTERVAL, "query_insights_executor");
        }
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() {
    }
}

