/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;

public final class QueryInsightsListener
extends SearchRequestOperationsListener {
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    private static final Logger log = LogManager.getLogger(QueryInsightsListener.class);
    private final QueryInsightsService queryInsightsService;

    @Inject
    public QueryInsightsListener(ClusterService clusterService, QueryInsightsService queryInsightsService) {
        this.queryInsightsService = queryInsightsService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_ENABLED, v -> this.setEnableTopQueries(MetricType.LATENCY, (boolean)v));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_SIZE, v -> this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).setTopNSize((int)v), v -> this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).validateTopNSize((int)v));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_WINDOW_SIZE, v -> this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).setWindowSize((TimeValue)v), v -> this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).validateWindowSize((TimeValue)v));
        this.setEnableTopQueries(MetricType.LATENCY, (Boolean)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_ENABLED));
        this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).setTopNSize((Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_SIZE));
        this.queryInsightsService.getTopQueriesService(MetricType.LATENCY).setWindowSize((TimeValue)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_LATENCY_QUERIES_WINDOW_SIZE));
    }

    public void setEnableTopQueries(MetricType metricType, boolean enabled) {
        boolean isAllMetricsDisabled = !this.queryInsightsService.isEnabled();
        this.queryInsightsService.enableCollection(metricType, enabled);
        if (!enabled) {
            if (!this.queryInsightsService.isEnabled()) {
                super.setEnabled(false);
                this.queryInsightsService.stop();
            }
        } else {
            super.setEnabled(true);
            if (isAllMetricsDisabled) {
                this.queryInsightsService.stop();
                this.queryInsightsService.start();
            }
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void onPhaseStart(SearchPhaseContext context) {
    }

    public void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    public void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
    }

    public void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        SearchRequest request = context.getRequest();
        try {
            HashMap<MetricType, Number> measurements = new HashMap<MetricType, Number>();
            if (this.queryInsightsService.isCollectionEnabled(MetricType.LATENCY)) {
                measurements.put(MetricType.LATENCY, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - searchRequestContext.getAbsoluteStartNanos()));
            }
            HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
            attributes.put(Attribute.SEARCH_TYPE, request.searchType().toString().toLowerCase(Locale.ROOT));
            attributes.put(Attribute.SOURCE, request.source().toString(FORMAT_PARAMS));
            attributes.put(Attribute.TOTAL_SHARDS, context.getNumShards());
            attributes.put(Attribute.INDICES, request.indices());
            attributes.put(Attribute.PHASE_LATENCY_MAP, searchRequestContext.phaseTookMap());
            SearchQueryRecord record = new SearchQueryRecord(request.getOrCreateAbsoluteStartMillis(), measurements, attributes);
            this.queryInsightsService.addRecord(record);
        }
        catch (Exception e) {
            log.error(String.format(Locale.ROOT, "fail to ingest query insight data, error: %s", e));
        }
    }
}

