/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public enum RcaVerticesMetrics implements MeasurementSet
{
    INVALID_OLD_GEN_SIZE("InvalidOldGenSize", "count", Collections.singletonList(Statistics.COUNT)),
    OLD_GEN_RECLAMATION_INEFFECTIVE("OldGenReclamationIneffective", "count", Collections.singletonList(Statistics.COUNT)),
    OLD_GEN_CONTENDED("OldGenContended", "count", Collections.singletonList(Statistics.COUNT)),
    OLD_GEN_OVER_OCCUPIED("OldGenOverOccupied", "count", Collections.singletonList(Statistics.COUNT)),
    HOT_SHARD_RCA_ERROR("HotShardRcaError", "count", Collections.singletonList(Statistics.COUNT)),
    NUM_YOUNG_GEN_RCA_TRIGGERED("YoungGenRcaCount", "count", Collections.singletonList(Statistics.COUNT)),
    NUM_OLD_GEN_RCA_TRIGGERED("OldGenRcaCount", "count", Collections.singletonList(Statistics.COUNT)),
    NUM_HIGH_HEAP_CLUSTER_RCA_TRIGGERED("HighHeapClusterRcaCount", "count", Collections.singletonList(Statistics.COUNT)),
    YOUNG_GEN_RCA_NAMED_COUNT("YoungGenRcaNamedCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    NUM_FIELD_DATA_CACHE_RCA_TRIGGERED("FieldDataCacheRcaCount", "count", Collections.singletonList(Statistics.COUNT)),
    NUM_SHARD_REQUEST_CACHE_RCA_TRIGGERED("ShardRequestCacheCount", "count", Collections.singletonList(Statistics.COUNT)),
    CLUSTER_RCA_NAMED_COUNT("ClusterRcaNamedCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    ADMISSION_CONTROL_RCA_TRIGGERED("AdmissionControlRcaCount", "count", Collections.singletonList(Statistics.COUNT));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private RcaVerticesMetrics(String name, String unit, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

