/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.metrics_generator.linux;

import java.util.Map;
import java.util.Set;
import org.opensearch.performanceanalyzer.collectors.DiskMetrics;
import org.opensearch.performanceanalyzer.hwnet.Disks;
import org.opensearch.performanceanalyzer.metrics_generator.DiskMetricsGenerator;

public class LinuxDiskMetricsGenerator
implements DiskMetricsGenerator {
    private Map<String, DiskMetrics> diskMetricsMap;

    @Override
    public Set<String> getAllDisks() {
        return this.diskMetricsMap.keySet();
    }

    @Override
    public double getDiskUtilization(String disk) {
        return this.diskMetricsMap.get((Object)disk).utilization;
    }

    @Override
    public double getAwait(String disk) {
        return this.diskMetricsMap.get((Object)disk).await;
    }

    @Override
    public double getServiceRate(String disk) {
        return this.diskMetricsMap.get((Object)disk).serviceRate;
    }

    @Override
    public void addSample() {
        Disks.addSample();
    }

    public void setDiskMetricsMap(Map<String, DiskMetrics> map) {
        this.diskMetricsMap = map;
    }
}

