/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.CacheClearAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyQueueCapacityAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.QueueActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.DeciderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelThreeActionBuilderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class LevelThreeActionBuilder {
    private final AppContext appContext;
    private final RcaConf rcaConf;
    private final NodeKey nodeKey;
    private final List<Action> actions;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final LevelThreeActionBuilderConfig actionBuilderConfig;
    private final CacheActionConfig cacheActionConfig;
    private final QueueActionConfig queueActionConfig;

    private LevelThreeActionBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        this.appContext = appContext;
        this.rcaConf = rcaConf;
        this.nodeKey = nodeKey;
        DeciderConfig deciderConfig = rcaConf.getDeciderConfig();
        this.oldGenDecisionPolicyConfig = rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        this.actionBuilderConfig = deciderConfig.getOldGenDecisionPolicyConfig().levelThreeActionBuilderConfig();
        this.cacheActionConfig = rcaConf.getCacheActionConfig();
        this.queueActionConfig = rcaConf.getQueueActionConfig();
        this.actions = new ArrayList<Action>();
    }

    public static LevelThreeActionBuilder newBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        return new LevelThreeActionBuilder(nodeKey, appContext, rcaConf);
    }

    public void addFieldDataCacheAction() {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.FIELD_DATA_CACHE, this.appContext, this.rcaConf).increase(false).setDesiredCacheMaxSizeToMin().build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    public void addShardRequestCacheAction() {
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.SHARD_REQUEST_CACHE, this.appContext, this.rcaConf).increase(false).setDesiredCacheMaxSizeToMin().build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addWriteQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.WRITE_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.nodeKey, ResourceEnum.WRITE_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.writeQueueStepSize()).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addSearchQueueAction() {
        int stepSize = this.queueActionConfig.getStepSize(ResourceEnum.SEARCH_THREADPOOL);
        ModifyQueueCapacityAction action = ModifyQueueCapacityAction.newBuilder(this.nodeKey, ResourceEnum.SEARCH_THREADPOOL, this.appContext, this.rcaConf).increase(false).stepSize(stepSize * this.actionBuilderConfig.searchQueueStepSize()).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    private void addCacheClearAction() {
        CacheClearAction action = CacheClearAction.newBuilder(this.appContext).build();
        if (action.isActionable()) {
            this.actions.add(action);
        }
    }

    public List<Action> build() {
        this.addFieldDataCacheAction();
        this.addShardRequestCacheAction();
        this.addSearchQueueAction();
        this.addWriteQueueAction();
        this.addCacheClearAction();
        return this.actions;
    }
}

