/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public enum ReaderMetrics implements MeasurementSet
{
    NUM_PA_THREADS_STARTED("NumberOfPAThreadsStarted", "namedCount", Collections.singletonList(Statistics.COUNT)),
    NUM_PA_THREADS_ENDED("NumberOfPAThreadsEnded", "namedCount", Collections.singletonList(Statistics.COUNT)),
    READER_THREAD_STOPPED("ReaderThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    ERROR_HANDLER_THREAD_STOPPED("ErrorHandlerThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    GRPC_SERVER_THREAD_STOPPED("GRPCServerThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    WEB_SERVER_THREAD_STOPPED("WebServerThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    RCA_CONTROLLER_THREAD_STOPPED("RcaControllerThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    RCA_SCHEDULER_THREAD_STOPPED("RcaSchedulerThreadStopped", "count", Collections.singletonList(Statistics.COUNT)),
    READER_METRICS_EMIT_TIME("ReaderMetricsEmitTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    RCA_SCHEDULER_RESTART("RcaSchedulerRestart", "count", Collections.singletonList(Statistics.COUNT)),
    METRICSDB_FILE_SIZE("MetricsdbFileSize", "bytes", Arrays.asList(Statistics.MAX, Statistics.MEAN)),
    METRICSDB_NUM_FILES("MetricsdbNumFiles", "count", Statistics.SAMPLE),
    METRICSDB_SIZE_FILES("MetricsdbSizeFiles", "bytes", Statistics.SAMPLE),
    METRICSDB_NUM_UNCOMPRESSED_FILES("MetricsdbNumUncompressedFiles", "count", Statistics.SAMPLE),
    METRICSDB_SIZE_UNCOMPRESSED_FILES("MetricsdbSizeUncompressedFiles", "bytes", Statistics.SAMPLE),
    BATCH_METRICS_ENABLED("BatchMetricsEnabled", "count", Statistics.SAMPLE),
    BATCH_METRICS_HTTP_CLIENT_ERROR("BatchMetricsHttpClientError", "count", Statistics.COUNT),
    BATCH_METRICS_HTTP_HOST_ERROR("BatchMetricsHttpHostError", "count", Statistics.COUNT),
    BATCH_METRICS_HTTP_SUCCESS("BatchMetricsHttpSuccess", "count", Statistics.COUNT),
    BATCH_METRICS_EXCEEDED_MAX_DATAPOINTS("ExceededBatchMetricsMaxDatapoints", "count", Statistics.COUNT),
    BATCH_METRICS_QUERY_PROCESSING_TIME("BatchMetricsQueryProcessingTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    SHARD_STATE_EMITTER_EXECUTION_TIME("ShardStateEmitterExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    MASTER_THROTTLING_EMITTER_EXECUTION_TIME("MasterThrottlingEmitterExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    FAULT_DETECTION_METRICS_EMITTER_EXECUTION_TIME("FaultDetectionMetricsEmitterExecutionTime", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    BLOCKED_TRANSPORT_THREAD_COUNT("BlockedTransportThreadCount", "count", Statistics.MAX),
    WAITED_TRANSPORT_THREAD_COUNT("WaitedTransportThreadCount", "count", Statistics.MAX),
    MAX_TRANSPORT_THREAD_BLOCKED_TIME("MaxTransportThreadBlockedTime", "seconds", Statistics.MAX),
    MAX_TRANSPORT_THREAD_WAITED_TIME("MaxTransportThreadWaitedTime", "seconds", Statistics.MAX),
    OTHER("Other", "count", Collections.singletonList(Statistics.COUNT));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private ReaderMetrics(String name, String unit, List<Statistics> stats) {
        this.name = name;
        this.unit = unit;
        this.statsList = stats;
    }

    private ReaderMetrics(String name, String unit, Statistics stats) {
        this(name, unit, Collections.singletonList(stats));
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

