/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.transport;

import com.google.common.annotations.VisibleForTesting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.transport.PerformanceAnalyzerTransportChannel;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

public class PerformanceAnalyzerTransportRequestHandler<T extends TransportRequest>
implements TransportRequestHandler<T> {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerTransportRequestHandler.class);
    private final PerformanceAnalyzerController controller;
    private TransportRequestHandler<T> actualHandler;
    boolean logOnce = false;

    PerformanceAnalyzerTransportRequestHandler(TransportRequestHandler<T> actualHandler, PerformanceAnalyzerController controller) {
        this.actualHandler = actualHandler;
        this.controller = controller;
    }

    PerformanceAnalyzerTransportRequestHandler<T> set(TransportRequestHandler<T> actualHandler) {
        this.actualHandler = actualHandler;
        return this;
    }

    public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
        this.actualHandler.messageReceived(request, this.getChannel(request, channel, task), task);
    }

    @VisibleForTesting
    TransportChannel getChannel(T request, TransportChannel channel, Task task) {
        if (!this.controller.isPerformanceAnalyzerEnabled()) {
            return channel;
        }
        if (request instanceof TransportReplicationAction.ConcreteShardRequest) {
            return this.getShardBulkChannel(request, channel, task);
        }
        return channel;
    }

    private TransportChannel getShardBulkChannel(T request, TransportChannel channel, Task task) {
        String className = request.getClass().getName();
        boolean bPrimary = false;
        if (className.equals("org.opensearch.action.support.replication.TransportReplicationAction$ConcreteShardRequest")) {
            bPrimary = true;
        } else if (className.equals("org.opensearch.action.support.replication.TransportReplicationAction$ConcreteReplicaRequest")) {
            bPrimary = false;
        } else {
            return channel;
        }
        TransportRequest transportRequest = ((TransportReplicationAction.ConcreteShardRequest)request).getRequest();
        if (!(transportRequest instanceof BulkShardRequest)) {
            return channel;
        }
        BulkShardRequest bsr = (BulkShardRequest)transportRequest;
        PerformanceAnalyzerTransportChannel performanceanalyzerChannel = new PerformanceAnalyzerTransportChannel();
        try {
            performanceanalyzerChannel.set(channel, System.currentTimeMillis(), bsr.index(), bsr.shardId().id(), bsr.items().length, bPrimary);
        }
        catch (Exception ex) {
            if (!this.logOnce) {
                LOG.error((Object)ex);
                this.logOnce = true;
            }
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
        return performanceanalyzerChannel;
    }
}

