/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByHeap;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByLargeHeap;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByMediumHeap;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlBySmallHeap;

public class AdmissionControlByHeapFactory {
    private static final int SMALL_HEAP_RCA_THRESHOLD = 4;
    private static final int MEDIUM_HEAP_RCA_THRESHOLD = 32;
    private static final String SMALL_HEAP = "SMALL_HEAP";
    private static final String MEDIUM_HEAP = "MEDIUM_HEAP";
    private static final String LARGE_HEAP = "LARGE_HEAP";
    private static final Map<String, AdmissionControlByHeap> rcaMap = new HashMap<String, AdmissionControlByHeap>();

    public static AdmissionControlByHeap getByMaxHeap(double maxHeap) {
        if (maxHeap <= 4.0) {
            if (!rcaMap.containsKey(SMALL_HEAP)) {
                rcaMap.put(SMALL_HEAP, new AdmissionControlBySmallHeap());
            }
            return rcaMap.get(SMALL_HEAP);
        }
        if (maxHeap <= 32.0) {
            if (!rcaMap.containsKey(MEDIUM_HEAP)) {
                rcaMap.put(MEDIUM_HEAP, new AdmissionControlByMediumHeap());
            }
            return rcaMap.get(MEDIUM_HEAP);
        }
        if (!rcaMap.containsKey(LARGE_HEAP)) {
            rcaMap.put(LARGE_HEAP, new AdmissionControlByLargeHeap());
        }
        return rcaMap.get(LARGE_HEAP);
    }
}

