/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.aggregators;

import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;

public class SummarizedWindow {
    private static final long tickExtension = 5000L;
    protected double sumCpuUtilization = 0.0;
    protected double sumHeapAllocRate = 0.0;
    protected long timeStampDistant = 0L;
    protected long timeStampRecent = 0L;

    protected void reset() {
        this.timeStampRecent = 0L;
        this.timeStampDistant = 0L;
        this.sumCpuUtilization = 0.0;
        this.sumHeapAllocRate = 0.0;
    }

    public void next(AllMetrics.OSMetrics metricType, double addend, long nextTimeStamp) {
        if (AllMetrics.OSMetrics.CPU_UTILIZATION.equals((Object)metricType)) {
            this.sumCpuUtilization += addend;
        } else {
            this.sumHeapAllocRate += addend;
        }
        if (this.timeStampDistant == 0L) {
            this.timeStampDistant = nextTimeStamp;
        } else {
            this.timeStampRecent = nextTimeStamp;
        }
    }

    public double readAvgMetricValue(TimeUnit timeUnit, AllMetrics.OSMetrics metricType) {
        if (AllMetrics.OSMetrics.CPU_UTILIZATION.equals((Object)metricType)) {
            return this.readAvgCpuUtilization(timeUnit);
        }
        return this.readAvgHeapAllocRate(timeUnit);
    }

    public double readAvgCpuUtilization(TimeUnit timeUnit) {
        if (this.empty()) {
            return Double.NaN;
        }
        long timestampDiff = this.timeStampRecent - this.timeStampDistant + 5000L;
        return this.sumCpuUtilization / ((double)timestampDiff / (double)timeUnit.toMillis(1L));
    }

    public double readAvgHeapAllocRate(TimeUnit timeUnit) {
        if (this.empty()) {
            return Double.NaN;
        }
        long timestampDiff = this.timeStampRecent - this.timeStampDistant + 5000L;
        return this.sumHeapAllocRate / ((double)timestampDiff / (double)timeUnit.toMillis(1L));
    }

    private boolean empty() {
        return this.timeStampDistant == 0L;
    }
}

