/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.MultiTenancyConfigValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class MultiTenancyConfigApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/tenancy/config"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/tenancy/config")));
    private static final Set<String> ACCEPTABLE_DEFAULT_TENANTS = ImmutableSet.of((Object)"", (Object)"global", (Object)"private");

    @Override
    public String getName() {
        return "Multi Tenancy actions to Retrieve / Update configs.";
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    public MultiTenancyConfigApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new MultiTenancyConfigValidator(request, ref, this.settings, params);
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.TENANTS;
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType getConfigName() {
        return CType.CONFIG;
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.DELETE);
    }

    private void multitenancyResponse(ConfigV7 config, RestChannel channel) {
        try (XContentBuilder contentBuilder = channel.newBuilder();){
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, contentBuilder.startObject().field("default_tenant", config.dynamic.kibana.default_tenant).field("private_tenant_enabled", config.dynamic.kibana.private_tenant_enabled).field("multitenancy_enabled", config.dynamic.kibana.multitenancy_enabled).endObject()));
        }
        catch (Exception e) {
            this.internalErrorResponse(channel, e.getMessage());
            this.log.error("Error handle request ", (Throwable)e);
        }
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> dynamicConfiguration = this.load(CType.CONFIG, false);
        ConfigV7 config = (ConfigV7)dynamicConfiguration.getCEntry(CType.CONFIG.toLCString());
        this.multitenancyResponse(config, channel);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> dynamicConfiguration = this.load(CType.CONFIG, false);
        final ConfigV7 config = (ConfigV7)dynamicConfiguration.getCEntry(CType.CONFIG.toLCString());
        this.updateAndValidatesValues(config, content);
        dynamicConfiguration.putCEntry(CType.CONFIG.toLCString(), config);
        MultiTenancyConfigApiAction.saveAndUpdateConfigs(this.securityIndexName, client, this.getConfigName(), dynamicConfiguration, (ActionListener<IndexResponse>)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                MultiTenancyConfigApiAction.this.multitenancyResponse(config, channel);
            }
        });
    }

    private void updateAndValidatesValues(ConfigV7 config, JsonNode jsonContent) {
        if (Objects.nonNull(jsonContent.findValue("default_tenant"))) {
            config.dynamic.kibana.default_tenant = jsonContent.findValue("default_tenant").asText();
        }
        if (Objects.nonNull(jsonContent.findValue("private_tenant_enabled"))) {
            config.dynamic.kibana.private_tenant_enabled = jsonContent.findValue("private_tenant_enabled").booleanValue();
        }
        if (Objects.nonNull(jsonContent.findValue("multitenancy_enabled"))) {
            config.dynamic.kibana.multitenancy_enabled = jsonContent.findValue("multitenancy_enabled").asBoolean();
        }
        String defaultTenant = Optional.ofNullable(config.dynamic.kibana.default_tenant).map(String::toLowerCase).orElse("");
        if (!config.dynamic.kibana.private_tenant_enabled && "private".equals(defaultTenant)) {
            throw new IllegalArgumentException("Private tenant can not be disabled if it is the default tenant.");
        }
        if (ACCEPTABLE_DEFAULT_TENANTS.contains(defaultTenant)) {
            return;
        }
        Set availableTenants = this.cl.getConfiguration(CType.TENANTS).getCEntries().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (!availableTenants.contains(defaultTenant)) {
            throw new IllegalArgumentException(config.dynamic.kibana.default_tenant + " can not be set to default tenant. Default tenant should be selected from one of the available tenants.");
        }
    }
}

