/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.NoOpValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class AuthTokenProcessorAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/authtoken")));

    @Inject
    public AuthTokenProcessorAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) {
        return true;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.successResponse(channel, "");
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new NoOpValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return "authtoken";
    }

    @Override
    protected CType getConfigName() {
        return null;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.AUTHTOKEN;
    }

    public static class Response {
        private String authorization;

        public String getAuthorization() {
            return this.authorization;
        }

        public void setAuthorization(String authorization) {
            this.authorization = authorization;
        }
    }
}

