/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.compliance;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComplianceConfig {
    private static final Logger log = LogManager.getLogger(ComplianceConfig.class);
    public static final ComplianceConfig DEFAULT = ComplianceConfig.from(Settings.EMPTY);
    private static final int CACHE_SIZE = 1000;
    private static final String INTERNAL_OPENSEARCH = "internal_opensearch";
    public static Set<String> FIELDS = DefaultObjectMapper.getFields(ComplianceConfig.class);
    private final boolean logExternalConfig;
    private final boolean logInternalConfig;
    private final boolean logReadMetadataOnly;
    private final boolean logWriteMetadataOnly;
    @JsonProperty(value="write_log_diffs")
    private final boolean logDiffsForWrite;
    @JsonProperty(value="read_watched_fields")
    private final Map<String, List<String>> watchedReadFields;
    @JsonProperty(value="read_ignore_users")
    private final Set<String> ignoredComplianceUsersForRead;
    @JsonProperty(value="write_watched_indices")
    private final List<String> watchedWriteIndicesPatterns;
    @JsonProperty(value="write_ignore_users")
    private final Set<String> ignoredComplianceUsersForWrite;
    private final WildcardMatcher watchedWriteIndicesMatcher;
    private final WildcardMatcher ignoredComplianceUsersForReadMatcher;
    private final WildcardMatcher ignoredComplianceUsersForWriteMatcher;
    private final String securityIndex;
    private final Map<WildcardMatcher, Set<String>> readEnabledFields;
    private final LoadingCache<String, WildcardMatcher> readEnabledFieldsCache;
    private final DateTimeFormatter auditLogPattern;
    private final String auditLogIndex;
    private final boolean enabled;

    private ComplianceConfig(boolean enabled, boolean logExternalConfig, boolean logInternalConfig, boolean logReadMetadataOnly, Map<String, List<String>> watchedReadFields, Set<String> ignoredComplianceUsersForRead, boolean logWriteMetadataOnly, boolean logDiffsForWrite, List<String> watchedWriteIndicesPatterns, Set<String> ignoredComplianceUsersForWrite, String securityIndex, String destinationType, String destinationIndex) {
        this.enabled = enabled;
        this.logExternalConfig = logExternalConfig;
        this.logInternalConfig = logInternalConfig;
        this.logReadMetadataOnly = logReadMetadataOnly;
        this.logWriteMetadataOnly = logWriteMetadataOnly;
        this.logDiffsForWrite = logDiffsForWrite;
        this.watchedWriteIndicesMatcher = WildcardMatcher.from(watchedWriteIndicesPatterns);
        this.ignoredComplianceUsersForReadMatcher = WildcardMatcher.from(ignoredComplianceUsersForRead);
        this.ignoredComplianceUsersForWriteMatcher = WildcardMatcher.from(ignoredComplianceUsersForWrite);
        this.securityIndex = securityIndex;
        this.watchedReadFields = watchedReadFields;
        this.ignoredComplianceUsersForRead = ignoredComplianceUsersForRead;
        this.watchedWriteIndicesPatterns = watchedWriteIndicesPatterns;
        this.ignoredComplianceUsersForWrite = ignoredComplianceUsersForWrite;
        this.readEnabledFields = (Map)watchedReadFields.entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getKey()))).collect(ImmutableMap.toImmutableMap(entry -> WildcardMatcher.from((String)entry.getKey()), entry -> ImmutableSet.copyOf((Collection)((Collection)entry.getValue()))));
        DateTimeFormatter auditLogPattern = null;
        String auditLogIndex = null;
        if (INTERNAL_OPENSEARCH.equalsIgnoreCase(destinationType)) {
            try {
                auditLogPattern = DateTimeFormat.forPattern((String)destinationIndex);
            }
            catch (IllegalArgumentException e) {
                auditLogIndex = destinationIndex;
            }
            catch (Exception e) {
                log.error("Unable to check if auditlog index {} is part of compliance setup", (Object)destinationIndex, (Object)e);
            }
        }
        this.auditLogPattern = auditLogPattern;
        this.auditLogIndex = auditLogIndex;
        this.readEnabledFieldsCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, WildcardMatcher>(){

            public WildcardMatcher load(String index) throws Exception {
                return WildcardMatcher.from(ComplianceConfig.this.getFieldsForIndex(index));
            }
        });
    }

    @VisibleForTesting
    public ComplianceConfig(boolean enabled, boolean logExternalConfig, boolean logInternalConfig, boolean logReadMetadataOnly, Map<String, List<String>> watchedReadFields, Set<String> ignoredComplianceUsersForRead, boolean logWriteMetadataOnly, boolean logDiffsForWrite, List<String> watchedWriteIndicesPatterns, Set<String> ignoredComplianceUsersForWrite, Settings settings) {
        this(enabled, logExternalConfig, logInternalConfig, logReadMetadataOnly, watchedReadFields, ignoredComplianceUsersForRead, logWriteMetadataOnly, logDiffsForWrite, watchedWriteIndicesPatterns, ignoredComplianceUsersForWrite, settings.get("plugins.security.config_index_name", ".opendistro_security"), settings.get("plugins.security.audit.type", null), settings.get("plugins.security.audit.config.index", "'security-auditlog-'YYYY.MM.dd"));
    }

    public void log(Logger logger) {
        logger.info("Auditing of external configuration is {}.", (Object)(this.logExternalConfig ? "enabled" : "disabled"));
        logger.info("Auditing of internal configuration is {}.", (Object)(this.logInternalConfig ? "enabled" : "disabled"));
        logger.info("Auditing only metadata information for read request is {}.", (Object)(this.logReadMetadataOnly ? "enabled" : "disabled"));
        logger.info("Auditing will watch {} for read requests.", this.readEnabledFields);
        logger.info("Auditing read operation requests from {} users is disabled.", (Object)this.ignoredComplianceUsersForReadMatcher);
        logger.info("Auditing only metadata information for write request is {}.", (Object)(this.logWriteMetadataOnly ? "enabled" : "disabled"));
        logger.info("Auditing diffs for write requests is {}.", (Object)(this.logDiffsForWrite ? "enabled" : "disabled"));
        logger.info("Auditing write operation requests from {} users is disabled.", (Object)this.ignoredComplianceUsersForWriteMatcher);
        logger.info("Auditing will watch {} for write requests.", (Object)this.watchedWriteIndicesMatcher);
        logger.info("{} is used as internal security index.", (Object)this.securityIndex);
        logger.info("Internal index used for posting audit logs is {}", (Object)this.auditLogIndex);
    }

    @JsonCreator
    @VisibleForTesting
    public static ComplianceConfig from(Map<String, Object> properties, @JacksonInject Settings settings) throws JsonProcessingException {
        if (!FIELDS.containsAll(properties.keySet())) {
            throw new UnrecognizedPropertyException(null, "Invalid property present in the input data for compliance config", null, ComplianceConfig.class, null, null);
        }
        boolean enabled = DefaultObjectMapper.getOrDefault(properties, "enabled", true);
        boolean logExternalConfig = DefaultObjectMapper.getOrDefault(properties, "external_config", false);
        boolean logInternalConfig = DefaultObjectMapper.getOrDefault(properties, "internal_config", false);
        boolean logReadMetadataOnly = DefaultObjectMapper.getOrDefault(properties, "read_metadata_only", false);
        Map<String, List<String>> watchedReadFields = DefaultObjectMapper.getOrDefault(properties, "read_watched_fields", Collections.emptyMap());
        ImmutableSet ignoredComplianceUsersForRead = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, "read_ignore_users", AuditConfig.DEFAULT_IGNORED_USERS));
        boolean logWriteMetadataOnly = DefaultObjectMapper.getOrDefault(properties, "write_metadata_only", false);
        boolean logDiffsForWrite = DefaultObjectMapper.getOrDefault(properties, "write_log_diffs", false);
        List<String> watchedWriteIndicesPatterns = DefaultObjectMapper.getOrDefault(properties, "write_watched_indices", Collections.emptyList());
        ImmutableSet ignoredComplianceUsersForWrite = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, "write_ignore_users", AuditConfig.DEFAULT_IGNORED_USERS));
        return new ComplianceConfig(enabled, logExternalConfig, logInternalConfig, logReadMetadataOnly, watchedReadFields, (Set<String>)ignoredComplianceUsersForRead, logWriteMetadataOnly, logDiffsForWrite, watchedWriteIndicesPatterns, (Set<String>)ignoredComplianceUsersForWrite, settings);
    }

    public static ComplianceConfig from(Settings settings) {
        boolean logExternalConfig = settings.getAsBoolean("opendistro_security.compliance.history.external_config_enabled", Boolean.valueOf(false));
        boolean logInternalConfig = settings.getAsBoolean("opendistro_security.compliance.history.internal_config_enabled", Boolean.valueOf(false));
        boolean logReadMetadataOnly = settings.getAsBoolean("opendistro_security.compliance.history.read.metadata_only", Boolean.valueOf(false));
        boolean logWriteMetadataOnly = settings.getAsBoolean("opendistro_security.compliance.history.write.metadata_only", Boolean.valueOf(false));
        boolean logDiffsForWrite = settings.getAsBoolean("opendistro_security.compliance.history.write.log_diffs", Boolean.valueOf(false));
        List watchedReadFields = settings.getAsList("opendistro_security.compliance.history.read.watched_fields", Collections.emptyList(), Boolean.valueOf(false));
        Map readEnabledFields = (Map)watchedReadFields.stream().map(watchedReadField -> watchedReadField.split(",")).filter(split -> ((String[])split).length != 0 && !Strings.isNullOrEmpty((String)split[0])).collect(ImmutableMap.toImmutableMap(split -> split[0], split -> ((String[])split).length == 1 ? ImmutableList.of((Object)"*") : (List)Arrays.stream(split).skip(1L).collect(ImmutableList.toImmutableList())));
        List watchedWriteIndices = settings.getAsList("opendistro_security.compliance.history.write.watched_indices", Collections.emptyList());
        Set<String> ignoredComplianceUsersForRead = ConfigConstants.getSettingAsSet(settings, "opendistro_security.compliance.history.read.ignore_users", AuditConfig.DEFAULT_IGNORED_USERS, false);
        Set<String> ignoredComplianceUsersForWrite = ConfigConstants.getSettingAsSet(settings, "opendistro_security.compliance.history.write.ignore_users", AuditConfig.DEFAULT_IGNORED_USERS, false);
        return new ComplianceConfig(true, logExternalConfig, logInternalConfig, logReadMetadataOnly, readEnabledFields, ignoredComplianceUsersForRead, logWriteMetadataOnly, logDiffsForWrite, watchedWriteIndices, ignoredComplianceUsersForWrite, settings);
    }

    @JsonProperty(value="external_config")
    public boolean shouldLogExternalConfig() {
        return this.logExternalConfig;
    }

    @JsonProperty(value="internal_config")
    public boolean shouldLogInternalConfig() {
        return this.logInternalConfig;
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldLogDiffsForWrite() {
        return !this.shouldLogWriteMetadataOnly() && this.logDiffsForWrite;
    }

    @JsonProperty(value="write_metadata_only")
    public boolean shouldLogWriteMetadataOnly() {
        return this.logWriteMetadataOnly;
    }

    @JsonProperty(value="read_metadata_only")
    public boolean shouldLogReadMetadataOnly() {
        return this.logReadMetadataOnly;
    }

    @VisibleForTesting
    public WildcardMatcher getIgnoredComplianceUsersForReadMatcher() {
        return this.ignoredComplianceUsersForReadMatcher;
    }

    public boolean isComplianceReadAuditDisabled(String user) {
        return this.ignoredComplianceUsersForReadMatcher.test(user);
    }

    @VisibleForTesting
    public WildcardMatcher getIgnoredComplianceUsersForWriteMatcher() {
        return this.ignoredComplianceUsersForWriteMatcher;
    }

    public boolean isComplianceWriteAuditDisabled(String user) {
        return this.ignoredComplianceUsersForWriteMatcher.test(user);
    }

    @VisibleForTesting
    public Map<WildcardMatcher, Set<String>> getReadEnabledFields() {
        return this.readEnabledFields;
    }

    @VisibleForTesting
    public WildcardMatcher getWatchedWriteIndicesMatcher() {
        return this.watchedWriteIndicesMatcher;
    }

    @VisibleForTesting
    public String getSecurityIndex() {
        return this.securityIndex;
    }

    @VisibleForTesting
    public String getAuditLogIndex() {
        return this.auditLogIndex;
    }

    private Set<String> getFieldsForIndex(String index) {
        if (index == null) {
            return Collections.emptySet();
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return Collections.emptySet();
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return Collections.emptySet();
        }
        return (Set)this.readEnabledFields.entrySet().stream().filter(entry -> ((WildcardMatcher)entry.getKey()).test(index)).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private String getExpandedIndexName(DateTimeFormatter indexPattern, String index) {
        if (indexPattern == null) {
            return index;
        }
        return indexPattern.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    public boolean writeHistoryEnabledForIndex(String index) {
        if (index == null || !this.isEnabled()) {
            return false;
        }
        if (this.securityIndex.equals(index)) {
            return this.logInternalConfig;
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return false;
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return false;
        }
        return this.watchedWriteIndicesMatcher.test(index);
    }

    public boolean readHistoryEnabledForIndex(String index) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.securityIndex.equals(index)) {
            return this.logInternalConfig;
        }
        try {
            return this.readEnabledFieldsCache.get((Object)index) != WildcardMatcher.NONE;
        }
        catch (ExecutionException e) {
            log.warn("Failed to get index {} fields enabled for read from cache. Bypassing cache.", (Object)index, (Object)e);
            return this.getFieldsForIndex(index).isEmpty();
        }
    }

    public boolean readHistoryEnabledForField(String index, String field) {
        WildcardMatcher matcher;
        if (!this.isEnabled()) {
            return false;
        }
        if (this.securityIndex.equals(index)) {
            return this.logInternalConfig;
        }
        try {
            matcher = (WildcardMatcher)this.readEnabledFieldsCache.get((Object)index);
        }
        catch (ExecutionException e) {
            log.warn("Failed to get index {} fields enabled for read from cache. Bypassing cache.", (Object)index, (Object)e);
            matcher = WildcardMatcher.from(this.getFieldsForIndex(index));
        }
        return matcher.test(field);
    }
}

