/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher
extends BaseMatcher {
    private static final Map<String, String> REGEXEN = new HashMap<String, String>();

    public RegexMatcher(Context context) {
        super(context);
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Map.Entry<String, String> regexenRef : REGEXEN.entrySet()) {
            String name = regexenRef.getKey();
            Matcher rxMatch = Pattern.compile(regexenRef.getValue()).matcher(password);
            while (rxMatch.find()) {
                WipeableString token = new WipeableString(rxMatch.group());
                matches.add(MatchFactory.createRegexMatch(rxMatch.start(), rxMatch.start() + token.length() - 1, token, name, rxMatch));
            }
        }
        return this.sorted(matches);
    }

    static {
        REGEXEN.put("recent_year", "19\\d\\d|200\\d|201\\d|202\\d");
    }
}

