/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.transport;

import io.netty.handler.ssl.SslHandler;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TaskTransportChannel;
import org.opensearch.transport.TcpTransportChannel;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.netty4.Netty4TcpChannel;

public class SecuritySSLRequestHandler<T extends TransportRequest>
implements TransportRequestHandler<T> {
    private final String action;
    private final TransportRequestHandler<T> actualHandler;
    private final ThreadPool threadPool;
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrincipalExtractor principalExtractor;
    private final SslExceptionHandler errorHandler;
    private final SSLConfig SSLConfig;

    public SecuritySSLRequestHandler(String action, TransportRequestHandler<T> actualHandler, ThreadPool threadPool, PrincipalExtractor principalExtractor, SSLConfig SSLConfig2, SslExceptionHandler errorHandler) {
        this.action = action;
        this.actualHandler = actualHandler;
        this.threadPool = threadPool;
        this.principalExtractor = principalExtractor;
        this.SSLConfig = SSLConfig2;
        this.errorHandler = errorHandler;
    }

    protected ThreadContext getThreadContext() {
        if (this.threadPool == null) {
            return null;
        }
        return this.threadPool.getThreadContext();
    }

    public final void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
        ThreadContext threadContext = this.getThreadContext();
        if (SSLRequestHelper.containsBadHeader(threadContext, "_opendistro_security_ssl_")) {
            OpenSearchException exception = ExceptionUtils.createBadHeaderException();
            channel.sendResponse((Exception)((Object)exception));
            throw exception;
        }
        String channelType = channel.getChannelType();
        if (!channelType.equals("direct") && !channelType.equals("transport")) {
            channel = this.getInnerChannel(channel);
        }
        if (!"transport".equals(channel.getChannelType())) {
            this.messageReceivedDecorate(request, this.actualHandler, channel, task);
            return;
        }
        try {
            TransportChannel inner;
            Netty4TcpChannel nettyChannel = null;
            if (channel instanceof TaskTransportChannel) {
                inner = ((TaskTransportChannel)channel).getChannel();
                nettyChannel = (Netty4TcpChannel)((TcpTransportChannel)inner).getChannel();
            } else if (channel instanceof TcpTransportChannel) {
                inner = ((TcpTransportChannel)channel).getChannel();
                nettyChannel = (Netty4TcpChannel)inner;
            } else {
                throw new Exception("Invalid channel of type " + channel.getClass() + " (" + channel.getChannelType() + ")");
            }
            SslHandler sslhandler = (SslHandler)nettyChannel.getNettyChannel().pipeline().get("ssl_server");
            if (sslhandler == null) {
                if (this.SSLConfig.isDualModeEnabled()) {
                    this.log.info("Communication in dual mode. Skipping SSL handler check");
                    threadContext.putTransient("_opendistro_security_passive_security", (Object)Boolean.TRUE);
                    this.messageReceivedDecorate(request, this.actualHandler, channel, task);
                    return;
                }
                String msg = "No ssl handler found (SG 11)";
                OpenSearchException exception = new OpenSearchException("No ssl handler found (SG 11)", new Object[0]);
                channel.sendResponse((Exception)((Object)exception));
                throw exception;
            }
            Certificate[] peerCerts = sslhandler.engine().getSession().getPeerCertificates();
            Certificate[] localCerts = sslhandler.engine().getSession().getLocalCertificates();
            if (peerCerts != null && peerCerts.length > 0 && peerCerts[0] instanceof X509Certificate && localCerts != null && localCerts.length > 0 && localCerts[0] instanceof X509Certificate) {
                X509Certificate[] x509PeerCerts = (X509Certificate[])Arrays.copyOf(peerCerts, peerCerts.length, X509Certificate[].class);
                X509Certificate[] x509LocalCerts = (X509Certificate[])Arrays.copyOf(localCerts, localCerts.length, X509Certificate[].class);
                String principal = this.principalExtractor == null ? null : this.principalExtractor.extractPrincipal(x509PeerCerts[0], PrincipalExtractor.Type.TRANSPORT);
                this.addAdditionalContextValues(this.action, (TransportRequest)request, x509LocalCerts, x509PeerCerts, principal);
                if (threadContext != null) {
                    threadContext.putTransient("_opendistro_security_ssl_transport_principal", (Object)principal);
                    threadContext.putTransient("_opendistro_security_ssl_transport_peer_certificates", (Object)x509PeerCerts);
                    threadContext.putTransient("_opendistro_security_ssl_transport_local_certificates", (Object)x509LocalCerts);
                    threadContext.putTransient("_opendistro_security_ssl_transport_protocol", (Object)sslhandler.engine().getSession().getProtocol());
                    threadContext.putTransient("_opendistro_security_ssl_transport_cipher", (Object)sslhandler.engine().getSession().getCipherSuite());
                }
            } else {
                String msg = "No X509 transport client certificates found (SG 12)";
                OpenSearchException exception = new OpenSearchException("No X509 transport client certificates found (SG 12)", new Object[0]);
                this.errorHandler.logError(exception, (TransportRequest)request, this.action, task, 0);
                channel.sendResponse((Exception)((Object)exception));
                throw exception;
            }
            this.messageReceivedDecorate(request, this.actualHandler, channel, task);
        }
        catch (SSLPeerUnverifiedException e) {
            this.errorHandler.logError(e, (TransportRequest)request, this.action, task, 0);
            OpenSearchException exception = ExceptionsHelper.convertToOpenSearchException((Exception)e);
            channel.sendResponse((Exception)((Object)exception));
            throw exception;
        }
        catch (Exception e) {
            this.errorHandler.logError(e, (TransportRequest)request, this.action, task, 0);
            throw e;
        }
    }

    protected TransportChannel getInnerChannel(TransportChannel transportChannel) throws Exception {
        try {
            Class<?> wrappedChannelCls = transportChannel.getClass();
            Method getInnerChannel = wrappedChannelCls.getMethod("getInnerChannel", new Class[0]);
            TransportChannel innerChannel = (TransportChannel)getInnerChannel.invoke((Object)transportChannel, new Object[0]);
            this.log.debug("Using inner transport channel " + innerChannel.getChannelType());
            return innerChannel;
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Unknown channel type " + transportChannel.getChannelType() + " does not implement getInnerChannel method.");
        }
    }

    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) throws Exception {
    }

    protected void messageReceivedDecorate(T request, TransportRequestHandler<T> actualHandler, TransportChannel transportChannel, Task task) throws Exception {
        actualHandler.messageReceived(request, transportChannel, task);
    }
}

