/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.RolesMappingValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class RolesMappingApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/rolesmapping/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/rolesmapping/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/rolesmapping/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/rolesmapping/{name}")));

    @Inject
    public RolesMappingApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> rolesConfiguration = this.load(CType.ROLES, false);
        SecurityDynamicConfiguration<?> rolesMappingConfiguration = this.load(this.getConfigName(), false);
        final boolean rolesMappingExists = rolesMappingConfiguration.exists(name);
        if (!this.isValidRolesMapping(channel, name)) {
            return;
        }
        if (this.restApiAdminPrivilegesEvaluator.containsRestApiAdminPermissions(rolesConfiguration.getCEntry(name)) && !this.isSuperAdmin()) {
            this.forbidden(channel, "No permissions");
            return;
        }
        rolesMappingConfiguration.putCObject(name, DefaultObjectMapper.readTree(content, rolesMappingConfiguration.getImplementingClass()));
        RolesMappingApiAction.saveAndUpdateConfigs(this.securityIndexName, client, this.getConfigName(), rolesMappingConfiguration, (ActionListener<IndexResponse>)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (rolesMappingExists) {
                    RolesMappingApiAction.this.successResponse(channel, "'" + name + "' updated.");
                } else {
                    RolesMappingApiAction.this.createdResponse(channel, "'" + name + "' created.");
                }
            }
        });
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) throws IOException {
        SecurityDynamicConfiguration<?> rolesConfiguration = this.load(CType.ROLES, false);
        if (this.restApiAdminPrivilegesEvaluator.containsRestApiAdminPermissions(rolesConfiguration.getCEntry(resourceName))) {
            return this.isSuperAdmin();
        }
        return true;
    }

    @Override
    protected boolean isReadOnly(SecurityDynamicConfiguration<?> existingConfiguration, String name) {
        SecurityDynamicConfiguration<?> rolesConfiguration = this.load(CType.ROLES, false);
        if (this.restApiAdminPrivilegesEvaluator.containsRestApiAdminPermissions(rolesConfiguration.getCEntry(name))) {
            return !this.isSuperAdmin();
        }
        return super.isReadOnly(existingConfiguration, name);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ROLESMAPPING;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new RolesMappingValidator(request, this.isSuperAdmin(), ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return "rolesmapping";
    }

    @Override
    protected CType getConfigName() {
        return CType.ROLESMAPPING;
    }
}

