/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.ConfigUpdateNodeResponse;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.RestApiPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractApiAction
extends BaseRestHandler {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected final ConfigurationRepository cl;
    protected final ClusterService cs;
    final ThreadPool threadPool;
    protected String securityIndexName;
    private final RestApiPrivilegesEvaluator restApiPrivilegesEvaluator;
    protected final RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator;
    protected final AuditLog auditLog;
    protected final Settings settings;

    protected AbstractApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        this.settings = settings;
        this.securityIndexName = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.cl = cl;
        this.cs = cs;
        this.threadPool = threadPool;
        this.restApiPrivilegesEvaluator = new RestApiPrivilegesEvaluator(settings, adminDNs, evaluator, principalExtractor, configPath, threadPool);
        this.restApiAdminPrivilegesEvaluator = new RestApiAdminPrivilegesEvaluator(threadPool.getThreadContext(), evaluator, adminDNs, settings.getAsBoolean("plugins.security.restapi.admin.enabled", Boolean.valueOf(false)));
        this.auditLog = auditLog;
    }

    protected abstract AbstractConfigurationValidator getValidator(RestRequest var1, BytesReference var2, Object ... var3);

    protected abstract String getResourceName();

    protected abstract CType getConfigName();

    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        AbstractConfigurationValidator validator = this.getValidator(request, request.content(), new Object[0]);
        if (!validator.validate()) {
            request.params().clear();
            this.badRequestResponse(channel, validator);
            return;
        }
        switch (request.method()) {
            case DELETE: {
                this.handleDelete(channel, request, client, validator.getContentAsNode());
                break;
            }
            case POST: {
                this.handlePost(channel, request, client, validator.getContentAsNode());
                break;
            }
            case PUT: {
                this.handlePut(channel, request, client, validator.getContentAsNode());
                break;
            }
            case GET: {
                this.handleGet(channel, request, client, validator.getContentAsNode());
                break;
            }
            default: {
                throw new IllegalArgumentException(request.method() + " not supported");
            }
        }
    }

    protected void handleDelete(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> existingConfiguration = this.load(this.getConfigName(), false);
        if (!this.isWriteable(channel, existingConfiguration, name)) {
            return;
        }
        boolean existed = existingConfiguration.exists(name);
        existingConfiguration.remove(name);
        if (existed) {
            AbstractApiAction.saveAndUpdateConfigs(this.securityIndexName, client, this.getConfigName(), existingConfiguration, (ActionListener<IndexResponse>)new OnSucessActionListener<IndexResponse>(channel){

                public void onResponse(IndexResponse response) {
                    AbstractApiAction.this.successResponse(channel, "'" + name + "' deleted.");
                }
            });
        } else {
            this.notFound(channel, this.getResourceName() + " " + name + " not found.");
        }
    }

    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> existingConfiguration = this.load(this.getConfigName(), false);
        if (existingConfiguration.getSeqNo() < 0L) {
            this.forbidden(channel, "Security index need to be updated to support '" + this.getConfigName().toLCString() + "'. Use SecurityAdmin to populate.");
            return;
        }
        if (!this.isWriteable(channel, existingConfiguration, name)) {
            return;
        }
        if (this.isReadonlyFieldUpdated(existingConfiguration, content)) {
            this.conflict(channel, "Attempted to update read-only property.");
            return;
        }
        if (this.log.isTraceEnabled() && content != null) {
            this.log.trace(content.toString());
        }
        final boolean existed = existingConfiguration.exists(name);
        Object newContent = DefaultObjectMapper.readTree(content, existingConfiguration.getImplementingClass());
        if (!this.hasPermissionsToCreate(existingConfiguration, newContent, this.getResourceName())) {
            this.forbidden(channel, "No permissions");
            return;
        }
        existingConfiguration.putCObject(name, newContent);
        AbstractApiAction.saveAndUpdateConfigs(this.securityIndexName, client, this.getConfigName(), existingConfiguration, (ActionListener<IndexResponse>)new OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (existed) {
                    AbstractApiAction.this.successResponse(channel, "'" + name + "' updated.");
                } else {
                    AbstractApiAction.this.createdResponse(channel, "'" + name + "' created.");
                }
            }
        });
    }

    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) throws IOException {
        return false;
    }

    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        String resourcename = request.param("name");
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        if (resourcename == null || resourcename.length() == 0) {
            this.successResponse(channel, configuration);
            return;
        }
        if (!configuration.exists(resourcename)) {
            this.notFound(channel, "Resource '" + resourcename + "' not found.");
            return;
        }
        configuration.removeOthers(resourcename);
        this.successResponse(channel, configuration);
    }

    protected final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent) {
        SecurityDynamicConfiguration<?> loaded = this.cl.getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    protected final SecurityDynamicConfiguration<?> load(CType config, boolean logComplianceEvent, boolean acceptInvalid) {
        SecurityDynamicConfiguration<?> loaded = this.cl.getConfigurationsFromIndex(Collections.singleton(config), logComplianceEvent, acceptInvalid).get((Object)config).deepClone();
        return DynamicConfigFactory.addStatics(loaded);
    }

    protected boolean ensureIndexExists() {
        return this.cs.state().metadata().hasConcreteIndex(this.securityIndexName);
    }

    protected void filter(SecurityDynamicConfiguration<?> builder) {
        if (!this.isSuperAdmin()) {
            builder.removeHidden();
        }
        builder.set_meta(null);
    }

    protected boolean isReadonlyFieldUpdated(JsonNode existingResource, JsonNode targetResource) {
        return false;
    }

    protected boolean isReadonlyFieldUpdated(SecurityDynamicConfiguration<?> configuration, JsonNode targetResource) {
        return false;
    }

    public static void saveAndUpdateConfigs(String indexName, Client client, CType cType, SecurityDynamicConfiguration<?> configuration, ActionListener<IndexResponse> actionListener) {
        IndexRequest ir = new IndexRequest(indexName);
        String id = cType.toLCString();
        configuration.removeStatic();
        try {
            client.index(((IndexRequest)ir.id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setIfSeqNo(configuration.getSeqNo()).setIfPrimaryTerm(configuration.getPrimaryTerm()).source(new Object[]{id, XContentHelper.toXContent(configuration, (XContentType)XContentType.JSON, (boolean)false)}), new ConfigUpdatingActionListener<IndexResponse>(new String[]{id}, client, actionListener));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String userName;
        this.consumeParameters(request);
        if (!this.ensureIndexExists()) {
            return channel -> this.internalErrorResponse((RestChannel)channel, AbstractConfigurationValidator.ErrorType.SECURITY_NOT_INITIALIZED.getMessage());
        }
        String authError = this.restApiPrivilegesEvaluator.checkAccessPermissions(request, this.getEndpoint());
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        String string = userName = user == null ? null : user.getName();
        if (authError != null) {
            this.log.error("No permission to access REST API: " + authError);
            this.auditLog.logMissingPrivileges(authError, userName, request);
            request.params().clear();
            return channel -> this.forbidden((RestChannel)channel, "No permission to access REST API: " + authError);
        }
        this.auditLog.logGrantedPrivileges(userName, request);
        Object originalUser = this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        Object originalRemoteAddress = this.threadPool.getThreadContext().getTransient("_opendistro_security_remote_address");
        Object originalOrigin = this.threadPool.getThreadContext().getTransient("_opendistro_security_origin");
        return channel -> this.threadPool.generic().submit(() -> {
            try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
                this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
                this.threadPool.getThreadContext().putTransient("_opendistro_security_user", originalUser);
                this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", originalRemoteAddress);
                this.threadPool.getThreadContext().putTransient("_opendistro_security_origin", originalOrigin);
                this.handleApiRequest((RestChannel)channel, request, (Client)client);
            }
            catch (Exception e) {
                this.log.error("Error processing request {}", (Object)request, (Object)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (IOException ioe) {
                    throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
                }
            }
        });
    }

    protected boolean checkConfigUpdateResponse(ConfigUpdateResponse response) {
        boolean success;
        int nodeCount = this.cs.state().getNodes().getNodes().size();
        boolean expectedConfigCount = true;
        boolean bl = success = response.getNodes().size() == nodeCount;
        if (!success) {
            this.log.error("Expected " + nodeCount + " nodes to return response, but got only " + response.getNodes().size());
        }
        for (String nodeId : response.getNodesMap().keySet()) {
            boolean successNode;
            ConfigUpdateNodeResponse node = (ConfigUpdateNodeResponse)((Object)response.getNodesMap().get(nodeId));
            boolean bl2 = successNode = node.getUpdatedConfigTypes() != null && node.getUpdatedConfigTypes().length == 1;
            if (!successNode) {
                this.log.error("Expected 1 config types for node " + nodeId + " but got only " + Arrays.toString(node.getUpdatedConfigTypes()));
            }
            success = success && successNode;
        }
        return success;
    }

    protected static XContentBuilder convertToJson(RestChannel channel, ToXContent toxContent) {
        try {
            XContentBuilder builder = channel.newBuilder();
            toxContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected void response(RestChannel channel, RestStatus status, String message) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field("status", status.name());
            builder.field("message", message);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected void successResponse(RestChannel channel, SecurityDynamicConfiguration<?> response) {
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, AbstractApiAction.convertToJson(channel, response)));
    }

    protected void successResponse(RestChannel channel) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
        catch (IOException e) {
            this.internalErrorResponse(channel, "Unable to fetch license: " + e.getMessage());
            this.log.error("Cannot fetch convert license to XContent due to", (Throwable)e);
        }
    }

    protected void badRequestResponse(RestChannel channel, AbstractConfigurationValidator validator) {
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, validator.errorsAsXContent(channel)));
    }

    protected void successResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.OK, message);
    }

    protected void createdResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.CREATED, message);
    }

    protected void badRequestResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.BAD_REQUEST, message);
    }

    protected void notFound(RestChannel channel, String message) {
        this.response(channel, RestStatus.NOT_FOUND, message);
    }

    protected void forbidden(RestChannel channel, String message) {
        this.response(channel, RestStatus.FORBIDDEN, message);
    }

    protected void internalErrorResponse(RestChannel channel, String message) {
        this.response(channel, RestStatus.INTERNAL_SERVER_ERROR, message);
    }

    protected void unprocessable(RestChannel channel, String message) {
        this.response(channel, RestStatus.UNPROCESSABLE_ENTITY, message);
    }

    protected void conflict(RestChannel channel, String message) {
        this.response(channel, RestStatus.CONFLICT, message);
    }

    protected void notImplemented(RestChannel channel, RestRequest.Method method) {
        this.response(channel, RestStatus.NOT_IMPLEMENTED, "Method " + method.name() + " not supported for this action.");
    }

    protected final boolean isReserved(SecurityDynamicConfiguration<?> configuration, String resourceName) {
        if (this.isStatic(configuration, resourceName)) {
            return true;
        }
        Object o = configuration.getCEntry(resourceName);
        return o != null && o instanceof Hideable && ((Hideable)o).isReserved();
    }

    protected final boolean isHidden(SecurityDynamicConfiguration<?> configuration, String resourceName) {
        return configuration.isHidden(resourceName) && !this.isSuperAdmin();
    }

    protected final boolean isStatic(SecurityDynamicConfiguration<?> configuration, String resourceName) {
        Object o = configuration.getCEntry(resourceName);
        return o != null && o instanceof StaticDefinable && ((StaticDefinable)o).isStatic();
    }

    protected void consumeParameters(RestRequest request) {
        request.param("name");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected abstract Endpoint getEndpoint();

    protected boolean isSuperAdmin() {
        return this.restApiAdminPrivilegesEvaluator.isCurrentUserRestApiAdminFor(this.getEndpoint());
    }

    protected boolean isReadOnly(SecurityDynamicConfiguration<?> existingConfiguration, String name) {
        return this.isSuperAdmin() ? false : this.isReserved(existingConfiguration, name);
    }

    protected boolean isValidRolesMapping(RestChannel channel, String role) {
        SecurityDynamicConfiguration<?> rolesConfiguration = this.load(CType.ROLES, false);
        SecurityDynamicConfiguration<?> rolesMappingConfiguration = this.load(CType.ROLESMAPPING, false);
        if (!rolesConfiguration.exists(role)) {
            this.notFound(channel, "Role '" + role + "' is not available for role-mapping.");
            return false;
        }
        if (this.isHidden(rolesConfiguration, role)) {
            this.notFound(channel, "Role '" + role + "' is not available for role-mapping.");
            return false;
        }
        return this.isWriteable(channel, rolesMappingConfiguration, role);
    }

    boolean isWriteable(RestChannel channel, SecurityDynamicConfiguration<?> configuration, String resourceName) {
        if (this.isHidden(configuration, resourceName)) {
            this.notFound(channel, "Resource '" + resourceName + "' is not available.");
            return false;
        }
        if (this.isReadOnly(configuration, resourceName)) {
            this.forbidden(channel, "Resource '" + resourceName + "' is read-only.");
            return false;
        }
        return true;
    }

    protected static class ConfigUpdatingActionListener<Response>
    implements ActionListener<Response> {
        private final String[] cTypes;
        private final Client client;
        private final ActionListener<Response> delegate;

        public ConfigUpdatingActionListener(String[] cTypes, Client client, ActionListener<Response> delegate) {
            this.cTypes = Objects.requireNonNull(cTypes, "cTypes must not be null");
            this.client = Objects.requireNonNull(client, "client must not be null");
            this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        }

        public void onResponse(final Response response) {
            ConfigUpdateRequest cur = new ConfigUpdateRequest(this.cTypes);
            this.client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)cur, (ActionListener)new ActionListener<ConfigUpdateResponse>(){

                public void onResponse(ConfigUpdateResponse ur) {
                    if (ur.hasFailures()) {
                        delegate.onFailure((Exception)ur.failures().get(0));
                        return;
                    }
                    delegate.onResponse(response);
                }

                public void onFailure(Exception e) {
                    delegate.onFailure(e);
                }
            });
        }

        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }

    abstract class OnSucessActionListener<Response>
    implements ActionListener<Response> {
        private final RestChannel channel;

        public OnSucessActionListener(RestChannel channel) {
            this.channel = channel;
        }

        public final void onFailure(Exception e) {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                AbstractApiAction.this.conflict(this.channel, e.getMessage());
            } else {
                AbstractApiAction.this.internalErrorResponse(this.channel, "Error " + e.getMessage());
            }
        }
    }
}

