/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.internal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.securityconf.InternalUsersModel;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;

public class InternalAuthenticationBackend
implements AuthenticationBackend,
AuthorizationBackend {
    private InternalUsersModel internalUsersModel;

    @Override
    public boolean exists(User user) {
        if (user == null || this.internalUsersModel == null) {
            return false;
        }
        boolean exists = this.internalUsersModel.exists(user.getName());
        if (exists) {
            List<String> securityRoles;
            user.addRoles(this.internalUsersModel.getBackenRoles(user.getName()));
            Map<String, String> customAttributes = this.internalUsersModel.getAttributes(user.getName());
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            if (customAttributes != null) {
                for (Map.Entry<String, String> attributeEntry : customAttributes.entrySet()) {
                    attributeMap.put("attr.internal." + attributeEntry.getKey(), attributeEntry.getValue());
                }
            }
            if ((securityRoles = this.internalUsersModel.getSecurityRoles(user.getName())) != null) {
                user.addSecurityRoles(securityRoles);
            }
            user.addAttributes(attributeMap);
            return true;
        }
        return false;
    }

    public boolean passwordMatchesHash(String hash, char[] array) {
        return OpenBSDBCrypt.checkPassword((String)hash, (char[])array);
    }

    @Override
    public User authenticate(AuthCredentials credentials) {
        String hash;
        byte[] password;
        boolean userExists;
        if (this.internalUsersModel == null) {
            throw new OpenSearchSecurityException("Internal authentication backend not configured. May be OpenSearch is not initialized.", new Object[0]);
        }
        if (!this.internalUsersModel.exists(credentials.getUsername())) {
            userExists = false;
            password = credentials.getPassword();
            hash = "$2y$12$NmKhjNssNgSIj8iXT7SYxeXvMA1E95a9tCt4cySY9FrQ4fB18xEc2";
        } else {
            userExists = true;
            password = credentials.getPassword();
            hash = this.internalUsersModel.getHash(credentials.getUsername());
        }
        if (password == null || password.length == 0) {
            throw new OpenSearchSecurityException("empty passwords not supported", new Object[0]);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (this.passwordMatchesHash(hash, array) && userExists) {
                List<String> roles = this.internalUsersModel.getBackenRoles(credentials.getUsername());
                Map<String, String> customAttributes = this.internalUsersModel.getAttributes(credentials.getUsername());
                if (customAttributes != null) {
                    for (Map.Entry<String, String> attributeName : customAttributes.entrySet()) {
                        credentials.addAttribute("attr.internal." + attributeName.getKey(), attributeName.getValue());
                    }
                }
                User user = new User(credentials.getUsername(), roles, credentials);
                List<String> securityRoles = this.internalUsersModel.getSecurityRoles(credentials.getUsername());
                if (securityRoles != null) {
                    user.addSecurityRoles(securityRoles);
                }
                User user2 = user;
                return user2;
            }
            if (!userExists) {
                throw new OpenSearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
            }
            throw new OpenSearchSecurityException("password does not match", new Object[0]);
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    @Override
    public String getType() {
        return "internal";
    }

    @Override
    public void fillRoles(User user, AuthCredentials credentials) throws OpenSearchSecurityException {
        List<String> roles;
        if (this.internalUsersModel == null) {
            throw new OpenSearchSecurityException("Internal authentication backend not configured. May be OpenSearch Security is not initialized.", new Object[0]);
        }
        if (this.exists(user) && (roles = this.internalUsersModel.getBackenRoles(user.getName())) != null && !roles.isEmpty() && user != null) {
            user.addRoles(roles);
        }
    }

    @Subscribe
    public void onInternalUsersModelChanged(InternalUsersModel ium) {
        this.internalUsersModel = ium;
    }
}

