/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.util.Collections;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.DeleteSearchPipelineRequest;
import org.opensearch.action.search.GetSearchPipelineRequest;
import org.opensearch.action.search.GetSearchPipelineResponse;
import org.opensearch.action.search.PutSearchPipelineRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Cancellable;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.SearchPipelineRequestConverters;

public final class SearchPipelineClient {
    private final RestHighLevelClient restHighLevelClient;

    SearchPipelineClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse put(PutSearchPipelineRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putAsync(PutSearchPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSearchPipelineResponse get(GetSearchPipelineRequest request, RequestOptions options) throws IOException {
        return (GetSearchPipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::getPipeline, options, GetSearchPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable getAsync(GetSearchPipelineRequest request, RequestOptions options, ActionListener<GetSearchPipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::getPipeline, options, GetSearchPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AcknowledgedResponse delete(DeleteSearchPipelineRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteAsync(DeleteSearchPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

