/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;

public class AuditConfigMigrater {
    private static final String AUDIT_YML = "audit.yml";
    private static final String OPENSEARCH_YML = "opensearch.yml";
    private static final String OPENSEARCH_AUDIT_FILTERED_YML = "opensearch.audit-filtered.yml";
    private static final String OPENSEARCH_PATH_CONF_ENV = "OPENSEARCH_PATH_CONF";
    private static final Options options = new Options();
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final CommandLineParser parser = new DefaultParser();

    public static void main(String[] args) {
        options.addOption(Option.builder((String)"s").argName("source").hasArg().desc("Path to opensearch.yml file to migrate. If not specified, will try to lookup env OPENSEARCH_PATH_CONF followed by lookup in current directory.").build());
        options.addOption(Option.builder((String)"oad").argName("output-audit-dir").hasArg().desc("Output directory to store the generated audit.yml file. To be uploaded in the index, the file must be present in config/opensearch-security/ or use securityadmin tool.").build());
        options.addOption(Option.builder((String)"oed").argName("output-opensearch-dir").hasArg().desc("Output directory to store the generated opensearch.audit-filtered.yml file.").build());
        try {
            CommandLine line = parser.parse(options, args);
            String opensearchPathConfDirEnv = System.getenv(OPENSEARCH_PATH_CONF_ENV);
            String opensearchPath = AuditConfigMigrater.sanitizeFilePath(opensearchPathConfDirEnv != null ? opensearchPathConfDirEnv : ".", OPENSEARCH_YML);
            String source = line.getOptionValue("s", opensearchPath);
            String auditOutput = AuditConfigMigrater.sanitizeFilePath(line.getOptionValue("oad", "."), AUDIT_YML);
            String opensearchOutput = AuditConfigMigrater.sanitizeFilePath(line.getOptionValue("oed", "."), OPENSEARCH_AUDIT_FILTERED_YML);
            System.out.println("Using source opensearch.yml file from path " + source);
            Settings.Builder settingsBuilder = Settings.builder().loadFromPath(Paths.get(source, new String[0]));
            ImmutableMap result = ImmutableMap.of((Object)"_meta", (Object)ImmutableMap.of((Object)"type", (Object)"audit", (Object)"config_version", (Object)2), (Object)"config", (Object)AuditConfig.from(settingsBuilder.build()));
            DefaultObjectMapper.YAML_MAPPER.writeValue(new File(auditOutput), (Object)result);
            System.out.println("Looking for deprecated keys in " + source);
            AuditConfig.DEPRECATED_KEYS.forEach(key -> {
                if (settingsBuilder.get(key) != null) {
                    System.out.println(" " + key);
                }
                settingsBuilder.remove(key);
            });
            try (FileOutputStream outputStream = new FileOutputStream(opensearchOutput);){
                XContentBuilder builder = new XContentBuilder(XContentType.YAML.xContent(), (OutputStream)outputStream);
                builder.startObject();
                settingsBuilder.build().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
                builder.close();
            }
            System.out.println("Generated audit.yml is available at path " + auditOutput);
            System.out.println("Generated opensearch.audit-filtered.yml is available at path " + opensearchOutput + " Please remove the deprecated keys from your opensearch.yml or replace with the generated file after reviewing.");
        }
        catch (Exception e) {
            e.printStackTrace();
            formatter.printHelp("audit_config_migrater.sh", options, true);
            System.exit(-1);
        }
    }

    private static String sanitizeFilePath(String path, String file) {
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return (String)path + file;
    }
}

