/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.EvaluatedDlsFlsConfig;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class ConfigModelV7
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private ActionGroupResolver agr = null;
    private SecurityRoles securityRoles = null;
    private TenantHolder tenantHolder;
    private RoleMappingHolder roleMappingHolder;
    private SecurityDynamicConfiguration<RoleV7> roles;
    private SecurityDynamicConfiguration<TenantV7> tenants;

    public ConfigModelV7(SecurityDynamicConfiguration<RoleV7> roles, SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, SecurityDynamicConfiguration<ActionGroupsV7> actiongroups, SecurityDynamicConfiguration<TenantV7> tenants, DynamicConfigModel dcm, Settings opensearchSettings) {
        this.roles = roles;
        this.tenants = tenants;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(opensearchSettings.get("plugins.security.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.agr = this.reloadActionGroups(actiongroups);
        this.securityRoles = this.reload(roles);
        this.tenantHolder = new TenantHolder(roles, tenants);
        this.roleMappingHolder = new RoleMappingHolder(rolemappings, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> getAllConfiguredTenantNames() {
        return Collections.unmodifiableSet(this.tenants.getCEntries().keySet());
    }

    @Override
    public SecurityRoles getSecurityRoles() {
        return this.securityRoles;
    }

    private ActionGroupResolver reloadActionGroups(final SecurityDynamicConfiguration<ActionGroupsV7> actionGroups) {
        return new ActionGroupResolver(){

            private Set<String> getGroupMembers(String groupname) {
                if (actionGroups == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet(this.resolve(actionGroups, groupname));
            }

            private Set<String> resolve(SecurityDynamicConfiguration<?> actionGroups2, String entry) {
                if (!actionGroups2.getCEntries().containsKey(entry)) {
                    return Collections.emptySet();
                }
                HashSet<String> ret = new HashSet<String>();
                Object actionGroupAsObject = actionGroups2.getCEntries().get(entry);
                if (actionGroupAsObject != null && actionGroupAsObject instanceof List) {
                    for (String perm : (List)actionGroupAsObject) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else if (actionGroupAsObject != null && actionGroupAsObject instanceof ActionGroupsV7) {
                    for (String perm : ((ActionGroupsV7)actionGroupAsObject).getAllowed_actions()) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else {
                    throw new RuntimeException("Unable to handle " + actionGroupAsObject);
                }
                return Collections.unmodifiableSet(ret);
            }

            @Override
            public Set<String> resolvedActions(List<String> actions) {
                HashSet<String> resolvedActions = new HashSet<String>();
                for (String string : actions) {
                    Set<String> groups = this.getGroupMembers(string);
                    if (groups.isEmpty()) {
                        resolvedActions.add(string);
                        continue;
                    }
                    resolvedActions.addAll(groups);
                }
                return Collections.unmodifiableSet(resolvedActions);
            }
        };
    }

    private SecurityRoles reload(SecurityDynamicConfiguration<RoleV7> settings) {
        HashSet<Future> futures = new HashSet<Future>(5000);
        ExecutorService execs = Executors.newFixedThreadPool(10);
        for (final Map.Entry<String, RoleV7> securityRole : settings.getCEntries().entrySet()) {
            Future future = execs.submit(new Callable<SecurityRole>(){

                @Override
                public SecurityRole call() throws Exception {
                    SecurityRole.Builder _securityRole = new SecurityRole.Builder((String)securityRole.getKey());
                    if (securityRole.getValue() == null) {
                        return null;
                    }
                    Set<String> permittedClusterActions = ConfigModelV7.this.agr.resolvedActions(((RoleV7)securityRole.getValue()).getCluster_permissions());
                    _securityRole.addClusterPerms(permittedClusterActions);
                    for (RoleV7.Index permittedAliasesIndex : ((RoleV7)securityRole.getValue()).getIndex_permissions()) {
                        String dls = permittedAliasesIndex.getDls();
                        List<String> fls = permittedAliasesIndex.getFls();
                        List<String> maskedFields = permittedAliasesIndex.getMasked_fields();
                        for (String pat : permittedAliasesIndex.getIndex_patterns()) {
                            IndexPattern _indexPattern = new IndexPattern(pat);
                            _indexPattern.setDlsQuery(dls);
                            _indexPattern.addFlsFields(fls);
                            _indexPattern.addMaskedFields(maskedFields);
                            _indexPattern.addPerm(ConfigModelV7.this.agr.resolvedActions(permittedAliasesIndex.getAllowed_actions()));
                            _securityRole.addIndexPattern(_indexPattern);
                        }
                    }
                    return _securityRole.build();
                }
            });
            futures.add(future);
        }
        execs.shutdown();
        try {
            execs.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (1) while loading roles");
            return null;
        }
        try {
            SecurityRoles _securityRoles = new SecurityRoles(futures.size());
            for (Future future : futures) {
                _securityRoles.addSecurityRole((SecurityRole)future.get());
            }
            return _securityRoles;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (2) while loading roles");
            return null;
        }
        catch (ExecutionException e) {
            this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    private static String replaceProperties(String orig, User user) {
        if (user == null || orig == null) {
            return orig;
        }
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = ConfigModelV7.replaceRoles(orig, user);
        orig = ConfigModelV7.replaceSecurityRoles(orig, user);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.roles}") || orig.contains("${user_roles}")) {
            String commaSeparatedRoles = ConfigModelV7.toQuotedCommaSeparatedString(user.getRoles());
            retVal = orig.replace("${user.roles}", commaSeparatedRoles).replace("${user_roles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String replaceSecurityRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.securityRoles}") || orig.contains("${user_securityRoles}")) {
            String commaSeparatedRoles = ConfigModelV7.toQuotedCommaSeparatedString(user.getSecurityRoles());
            retVal = orig.replace("${user.securityRoles}", commaSeparatedRoles).replace("${user_securityRoles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String toQuotedCommaSeparatedString(Set<String> roles) {
        return Joiner.on((char)',').join(Iterables.transform(roles, s -> new StringBuilder(s.length() + 2).append('\"').append((String)s).append('\"').toString()));
    }

    private static boolean impliesTypePerm(Set<IndexPattern> ipatterns, IndexResolverReplacer.Resolved resolved, User user, String[] requestedActions, IndexNameExpressionResolver resolver, ClusterService cs) {
        Set<String> resolvedRequestedIndices = resolved.getAllIndices();
        IndexMatcherAndPermissions[] indexMatcherAndPermissions = resolved.isLocalAll() ? (IndexMatcherAndPermissions[])ipatterns.stream().filter(indexPattern -> "*".equals(indexPattern.getUnresolvedIndexPattern(user))).map(p -> new IndexMatcherAndPermissions(p.attemptResolveIndexNames(user, resolver, cs), p.perms)).toArray(IndexMatcherAndPermissions[]::new) : (IndexMatcherAndPermissions[])ipatterns.stream().map(p -> new IndexMatcherAndPermissions(p.attemptResolveIndexNames(user, resolver, cs), p.perms)).toArray(IndexMatcherAndPermissions[]::new);
        return resolvedRequestedIndices.stream().allMatch(index -> Arrays.stream(requestedActions).allMatch(action -> Arrays.stream(indexMatcherAndPermissions).anyMatch(ipap -> ipap.matches((String)index, (String)action))));
    }

    @Override
    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.tenantHolder.mapTenants(user, roles);
    }

    @Override
    public Set<String> mapSecurityRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private static interface ActionGroupResolver {
        public Set<String> resolvedActions(List<String> var1);
    }

    public static class SecurityRoles
    implements org.opensearch.security.securityconf.SecurityRoles {
        protected final Logger log = LogManager.getLogger(this.getClass());
        final Set<SecurityRole> roles;

        private SecurityRoles(int roleCount) {
            this.roles = new HashSet<SecurityRole>(roleCount);
        }

        private SecurityRoles addSecurityRole(SecurityRole securityRole) {
            if (securityRole != null) {
                this.roles.add(securityRole);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRoles other = (SecurityRoles)obj;
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        public String toString() {
            return "roles=" + this.roles;
        }

        public Set<SecurityRole> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        @Override
        public Set<String> getRoleNames() {
            return this.getRoles().stream().map(r -> r.getName()).collect(Collectors.toSet());
        }

        @Override
        public SecurityRoles filter(Set<String> keep) {
            SecurityRoles retVal = new SecurityRoles(this.roles.size());
            for (SecurityRole sr : this.roles) {
                if (!keep.contains(sr.getName())) continue;
                retVal.addSecurityRole(sr);
            }
            return retVal;
        }

        @Override
        public EvaluatedDlsFlsConfig getDlsFls(User user, boolean dfmEmptyOverwritesAll, IndexNameExpressionResolver resolver, ClusterService cs, NamedXContentRegistry namedXContentRegistry) {
            if (!this.containsDlsFlsConfig()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No fls or dls found for {} in {} security roles", (Object)user, (Object)this.roles.size());
                }
                return EvaluatedDlsFlsConfig.EMPTY;
            }
            HashMap<String, Set<String>> dlsQueriesByIndex = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> flsFields = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> maskedFieldsMap = new HashMap<String, Set<String>>();
            HashSet<String> noDlsConcreteIndices = new HashSet<String>();
            HashSet<String> noFlsConcreteIndices = new HashSet<String>();
            HashSet<String> noMaskedFieldConcreteIndices = new HashSet<String>();
            for (SecurityRole role : this.roles) {
                for (IndexPattern ip : role.getIpatterns()) {
                    Set<String> set;
                    Set<String> fls;
                    Set<String> concreteIndices = ip.concreteIndexNames(user, resolver, cs);
                    String dls = ip.getDlsQuery(user);
                    if (dls != null && dls.length() > 0) {
                        for (String string : concreteIndices) {
                            dlsQueriesByIndex.computeIfAbsent(string, key -> new HashSet()).add(dls);
                        }
                    } else if (dfmEmptyOverwritesAll) {
                        noDlsConcreteIndices.addAll(concreteIndices);
                    }
                    if ((fls = ip.getFls()) != null && fls.size() > 0) {
                        for (String concreteIndex2 : concreteIndices) {
                            if (flsFields.containsKey(concreteIndex2)) {
                                ((Set)flsFields.get(concreteIndex2)).addAll(Sets.newHashSet(fls));
                                continue;
                            }
                            flsFields.put(concreteIndex2, new HashSet());
                            ((Set)flsFields.get(concreteIndex2)).addAll(Sets.newHashSet(fls));
                        }
                    } else if (dfmEmptyOverwritesAll) {
                        noFlsConcreteIndices.addAll(concreteIndices);
                    }
                    if ((set = ip.getMaskedFields()) != null && set.size() > 0) {
                        for (String concreteIndex : concreteIndices) {
                            if (maskedFieldsMap.containsKey(concreteIndex)) {
                                ((Set)maskedFieldsMap.get(concreteIndex)).addAll(Sets.newHashSet(set));
                                continue;
                            }
                            maskedFieldsMap.put(concreteIndex, new HashSet());
                            ((Set)maskedFieldsMap.get(concreteIndex)).addAll(Sets.newHashSet(set));
                        }
                        continue;
                    }
                    if (!dfmEmptyOverwritesAll) continue;
                    noMaskedFieldConcreteIndices.addAll(concreteIndices);
                }
            }
            if (dfmEmptyOverwritesAll) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Index patterns with no dls queries attached: {} - They will be removed from {}", noDlsConcreteIndices, dlsQueriesByIndex.keySet());
                    this.log.debug("Index patterns with no fls fields attached: {} - They will be removed from {}", noFlsConcreteIndices, flsFields.keySet());
                    this.log.debug("Index patterns with no masked fields attached: {} - They will be removed from {}", noMaskedFieldConcreteIndices, maskedFieldsMap.keySet());
                }
                dlsQueriesByIndex.keySet().removeAll(noDlsConcreteIndices);
                flsFields.keySet().removeAll(noFlsConcreteIndices);
                maskedFieldsMap.keySet().removeAll(noMaskedFieldConcreteIndices);
            }
            return new EvaluatedDlsFlsConfig(dlsQueriesByIndex, flsFields, maskedFieldsMap);
        }

        @Override
        public Set<String> getAllPermittedIndicesForDashboards(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved._LOCAL_ALL, user, actions, resolver, cs));
                retVal.addAll(resolved.getRemoteIndices());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public Set<String> reduce(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SecurityRole sr : this.roles) {
                retVal.addAll(sr.getAllResolvedPermittedIndices(resolved, user, actions, resolver, cs));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reduced requested resolved indices {} to permitted indices {}.", (Object)resolved, (Object)((Object)retVal).toString());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public boolean get(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            for (SecurityRole sr : this.roles) {
                if (!ConfigModelV7.impliesTypePerm(sr.getIpatterns(), resolved, user, actions, resolver, cs)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean impliesClusterPermissionPermission(String action) {
            return this.roles.stream().filter((? super T r) -> r.impliesClusterPermission(action)).count() > 0L;
        }

        @Override
        public boolean impliesTypePermGlobal(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<IndexPattern> ipatterns = new HashSet<IndexPattern>();
            this.roles.stream().forEach(p -> ipatterns.addAll(p.getIpatterns()));
            return ConfigModelV7.impliesTypePerm(ipatterns, resolved, user, actions, resolver, cs);
        }

        private boolean containsDlsFlsConfig() {
            for (SecurityRole role : this.roles) {
                for (IndexPattern ip : role.getIpatterns()) {
                    if (!ip.hasDlsQuery() && !ip.hasFlsFields() && !ip.hasMaskedFields()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class TenantHolder {
        private SetMultimap<String, Tuple<String, Boolean>> tenantsMM = null;

        public TenantHolder(SecurityDynamicConfiguration<RoleV7> roles, final SecurityDynamicConfiguration<TenantV7> definedTenants) {
            HashSet<Future> futures = new HashSet<Future>(roles.getCEntries().size());
            ExecutorService execs = Executors.newFixedThreadPool(10);
            for (final Map.Entry<String, RoleV7> securityRole : roles.getCEntries().entrySet()) {
                if (securityRole.getValue() == null) continue;
                Future future = execs.submit(new Callable<Tuple<String, Set<Tuple<String, Boolean>>>>(){

                    @Override
                    public Tuple<String, Set<Tuple<String, Boolean>>> call() throws Exception {
                        HashSet<Tuple> tuples = new HashSet<Tuple>();
                        List<RoleV7.Tenant> tenants = ((RoleV7)securityRole.getValue()).getTenant_permissions();
                        if (tenants != null) {
                            for (RoleV7.Tenant tenant : tenants) {
                                List matchingTenants = WildcardMatcher.from(tenant.getTenant_patterns()).getMatchAny(definedTenants.getCEntries().keySet(), Collectors.toList());
                                for (String matchingTenant : matchingTenants) {
                                    tuples.add(new Tuple((Object)matchingTenant, (Object)ConfigModelV7.this.agr.resolvedActions(tenant.getAllowed_actions()).contains("kibana:saved_objects/*/write")));
                                }
                                Pattern parameterPattern = Pattern.compile("^\\$\\{attr");
                                List matchingParameterTenantList = tenant.getTenant_patterns().stream().filter(parameterPattern.asPredicate()).collect(Collectors.toList());
                                for (String matchingParameterTenant : matchingParameterTenantList) {
                                    tuples.add(new Tuple((Object)matchingParameterTenant, (Object)ConfigModelV7.this.agr.resolvedActions(tenant.getAllowed_actions()).contains("kibana:saved_objects/*/write")));
                                }
                            }
                        }
                        return new Tuple((Object)((String)securityRole.getKey()), tuples);
                    }
                });
                futures.add(future);
            }
            execs.shutdown();
            try {
                execs.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (1) while loading roles");
                return;
            }
            try {
                SetMultimap tenantsMM_ = MultimapBuilder.SetMultimapBuilder.hashKeys((int)futures.size()).hashSetValues(16).build();
                for (Future future : futures) {
                    Tuple result = (Tuple)future.get();
                    tenantsMM_.putAll((Object)((String)result.v1()), (Iterable)result.v2());
                }
                this.tenantsMM = tenantsMM_;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (2) while loading roles");
                return;
            }
            catch (ExecutionException e) {
                ConfigModelV7.this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }

        public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
            if (user == null || this.tenantsMM == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(roles.size());
            result.put(user.getName(), true);
            this.tenantsMM.entries().stream().filter(e -> roles.contains(e.getKey())).filter(e -> !user.getName().equals(((Tuple)e.getValue()).v1())).forEach(e -> {
                String tenant = ConfigModelV7.replaceProperties((String)((Tuple)e.getValue()).v1(), user);
                boolean rw = (Boolean)((Tuple)e.getValue()).v2();
                if ((rw || !result.containsKey(tenant)) && ConfigModelV7.this.tenants.getCEntries().keySet().contains(tenant)) {
                    result.put(tenant, rw);
                }
            });
            if (!result.containsKey("global_tenant") && (roles.contains("kibana_user") || roles.contains("kibana_user") || roles.contains("all_access") || roles.contains("ALL_ACCESS"))) {
                result.put("global_tenant", true);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        private RoleMappingHolder(SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (ConfigModelV7.this.roles != null) {
                this.users = ArrayListMultimap.create();
                this.abars = ArrayListMultimap.create();
                this.bars = ArrayListMultimap.create();
                this.hosts = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                    String roleMapKey = roleMap.getKey();
                    RoleMappingsV7 roleMapValue = roleMap.getValue();
                    for (String u : roleMapValue.getUsers()) {
                        this.users.put((Object)u, (Object)roleMapKey);
                    }
                    HashSet<String> abar = new HashSet<String>(roleMapValue.getAnd_backend_roles());
                    if (!abar.isEmpty()) {
                        this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                    }
                    for (String bar : roleMapValue.getBackend_roles()) {
                        this.bars.put((Object)bar, (Object)roleMapKey);
                    }
                    for (String host : roleMapValue.getHosts()) {
                        this.hosts.put((Object)host, (Object)roleMapKey);
                    }
                }
                this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
                this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
                this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
            }
        }

        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            HashSet<String> securityRoles = new HashSet<String>(user.getSecurityRoles());
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV7.this.log.isDebugEnabled()) {
                    ConfigModelV7.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                securityRoles.addAll(user.getRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    securityRoles.addAll(this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    securityRoles.addAll(this.bars.get((Object)p2));
                }
                for (Object patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny(user.getRoles()))) continue;
                    securityRoles.addAll(this.abars.get(patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, ipAddress)) {
                        securityRoles.addAll(this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase("ip-hostname") || this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup"))) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, hostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup")) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, resolvedHostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(securityRoles);
        }
    }

    public static class SecurityRole {
        private final String name;
        private final Set<IndexPattern> ipatterns;
        private final WildcardMatcher clusterPerms;

        private SecurityRole(String name, Set<IndexPattern> ipatterns, WildcardMatcher clusterPerms) {
            this.name = Objects.requireNonNull(name);
            this.ipatterns = ipatterns;
            this.clusterPerms = clusterPerms;
        }

        private boolean impliesClusterPermission(String action) {
            return this.clusterPerms.test(action);
        }

        private Set<String> getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet retVal = new HashSet();
            for (IndexPattern p : this.ipatterns) {
                boolean patternMatch = p.getPerms().matchAll(actions);
                if (!patternMatch) continue;
                WildcardMatcher permitted = WildcardMatcher.from(p.attemptResolveIndexNames(user, resolver, cs));
                HashSet res = new HashSet();
                if (!(resolved.isLocalAll() || resolved.getAllIndices().contains("*") || resolved.getAllIndices().contains("_all"))) {
                    resolved.getAllIndices().stream().filter(permitted).forEach(res::add);
                } else {
                    String[] allIndices = cs.state().metadata().getConcreteAllOpenIndices();
                    Arrays.stream(allIndices).filter(permitted).forEach(res::add);
                }
                retVal.addAll(res);
            }
            return Collections.unmodifiableSet(retVal);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterPerms == null ? 0 : this.clusterPerms.hashCode());
            result = 31 * result + (this.ipatterns == null ? 0 : this.ipatterns.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityRole other = (SecurityRole)obj;
            if (this.clusterPerms == null ? other.clusterPerms != null : !this.clusterPerms.equals(other.clusterPerms)) {
                return false;
            }
            if (this.ipatterns == null ? other.ipatterns != null : !this.ipatterns.equals(other.ipatterns)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return System.lineSeparator() + "  " + this.name + System.lineSeparator() + "    ipatterns=" + this.ipatterns + System.lineSeparator() + "    clusterPerms=" + this.clusterPerms;
        }

        public Set<IndexPattern> getIpatterns() {
            return Collections.unmodifiableSet(this.ipatterns);
        }

        public String getName() {
            return this.name;
        }

        public static final class Builder {
            private final String name;
            private final Set<String> clusterPerms = new HashSet<String>();
            private final Set<IndexPattern> ipatterns = new HashSet<IndexPattern>();

            public Builder(String name) {
                this.name = Objects.requireNonNull(name);
            }

            public Builder addIndexPattern(IndexPattern indexPattern) {
                this.ipatterns.add(indexPattern);
                return this;
            }

            public Builder addClusterPerms(Collection<String> clusterPerms) {
                if (clusterPerms != null) {
                    this.clusterPerms.addAll(clusterPerms);
                }
                return this;
            }

            public SecurityRole build() {
                return new SecurityRole(this.name, this.ipatterns, WildcardMatcher.from(this.clusterPerms));
            }
        }
    }

    private static final class IndexMatcherAndPermissions {
        private WildcardMatcher matcher;
        private WildcardMatcher perms;

        public IndexMatcherAndPermissions(Set<String> patterns, Set<String> perms) {
            this.matcher = WildcardMatcher.from(patterns);
            this.perms = WildcardMatcher.from(perms);
        }

        public boolean matches(String index, String action) {
            return this.matcher.test(index) && this.perms.test(action);
        }
    }

    public static class IndexPattern {
        private final String indexPattern;
        private String dlsQuery;
        private final Set<String> fls = new HashSet<String>();
        private final Set<String> maskedFields = new HashSet<String>();
        private final Set<String> perms = new HashSet<String>();

        public IndexPattern(String indexPattern) {
            this.indexPattern = Objects.requireNonNull(indexPattern);
        }

        public IndexPattern addFlsFields(List<String> flsFields) {
            if (flsFields != null) {
                this.fls.addAll(flsFields);
            }
            return this;
        }

        public IndexPattern addMaskedFields(List<String> maskedFields) {
            if (maskedFields != null) {
                this.maskedFields.addAll(maskedFields);
            }
            return this;
        }

        public IndexPattern addPerm(Set<String> perms) {
            if (perms != null) {
                this.perms.addAll(perms);
            }
            return this;
        }

        public IndexPattern setDlsQuery(String dlsQuery) {
            if (dlsQuery != null) {
                this.dlsQuery = dlsQuery;
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dlsQuery == null ? 0 : this.dlsQuery.hashCode());
            result = 31 * result + (this.fls == null ? 0 : this.fls.hashCode());
            result = 31 * result + (this.maskedFields == null ? 0 : this.maskedFields.hashCode());
            result = 31 * result + (this.indexPattern == null ? 0 : this.indexPattern.hashCode());
            result = 31 * result + (this.perms == null ? 0 : this.perms.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPattern other = (IndexPattern)obj;
            if (this.dlsQuery == null ? other.dlsQuery != null : !this.dlsQuery.equals(other.dlsQuery)) {
                return false;
            }
            if (this.fls == null ? other.fls != null : !this.fls.equals(other.fls)) {
                return false;
            }
            if (this.maskedFields == null ? other.maskedFields != null : !this.maskedFields.equals(other.maskedFields)) {
                return false;
            }
            if (this.indexPattern == null ? other.indexPattern != null : !this.indexPattern.equals(other.indexPattern)) {
                return false;
            }
            return !(this.perms == null ? other.perms != null : !this.perms.equals(other.perms));
        }

        public String toString() {
            return System.lineSeparator() + "        indexPattern=" + this.indexPattern + System.lineSeparator() + "          dlsQuery=" + this.dlsQuery + System.lineSeparator() + "          fls=" + this.fls + System.lineSeparator() + "          perms=" + this.perms;
        }

        public String getUnresolvedIndexPattern(User user) {
            return ConfigModelV7.replaceProperties(this.indexPattern, user);
        }

        public Set<String> concreteIndexNames(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            return this.getResolvedIndexPattern(user, resolver, cs, false);
        }

        public Set<String> attemptResolveIndexNames(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            return this.getResolvedIndexPattern(user, resolver, cs, true);
        }

        public Set<String> getResolvedIndexPattern(User user, IndexNameExpressionResolver resolver, ClusterService cs, boolean appendUnresolved) {
            String[] aliasesAndDataStreamsForPermittedPattern;
            String unresolved = this.getUnresolvedIndexPattern(user);
            ImmutableSet.Builder resolvedIndices = new ImmutableSet.Builder();
            WildcardMatcher matcher = WildcardMatcher.from(unresolved);
            boolean includeDataStreams = true;
            if (!(matcher instanceof WildcardMatcher.Exact) && (aliasesAndDataStreamsForPermittedPattern = (String[])cs.state().getMetadata().getIndicesLookup().entrySet().stream().filter(e -> ((IndexAbstraction)e.getValue()).getType() == IndexAbstraction.Type.ALIAS || ((IndexAbstraction)e.getValue()).getType() == IndexAbstraction.Type.DATA_STREAM).filter(e -> matcher.test((String)e.getKey())).map(e -> (String)e.getKey()).toArray(String[]::new)).length > 0) {
                String[] resolvedAliasesAndDataStreamIndices = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), includeDataStreams, aliasesAndDataStreamsForPermittedPattern);
                resolvedIndices.addAll(Arrays.asList(resolvedAliasesAndDataStreamIndices));
            }
            if (Strings.isNotBlank((String)unresolved)) {
                String[] resolvedIndicesFromPattern = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), includeDataStreams, new String[]{unresolved});
                resolvedIndices.addAll(Arrays.asList(resolvedIndicesFromPattern));
            }
            if (appendUnresolved || resolvedIndices.build().isEmpty()) {
                resolvedIndices.add((Object)unresolved);
            }
            return resolvedIndices.build();
        }

        public String getDlsQuery(User user) {
            return ConfigModelV7.replaceProperties(this.dlsQuery, user);
        }

        public boolean hasDlsQuery() {
            return this.dlsQuery != null && !this.dlsQuery.isEmpty();
        }

        public Set<String> getFls() {
            return Collections.unmodifiableSet(this.fls);
        }

        public boolean hasFlsFields() {
            return this.fls != null && !this.fls.isEmpty();
        }

        public Set<String> getMaskedFields() {
            return Collections.unmodifiableSet(this.maskedFields);
        }

        public boolean hasMaskedFields() {
            return this.maskedFields != null && !this.maskedFields.isEmpty();
        }

        public WildcardMatcher getPerms() {
            return WildcardMatcher.from(this.perms);
        }
    }

    public static class Tenant {
        private final String tenant;
        private final boolean readWrite;

        private Tenant(String tenant, boolean readWrite) {
            this.tenant = tenant;
            this.readWrite = readWrite;
        }

        public String getTenant() {
            return this.tenant;
        }

        public boolean isReadWrite() {
            return this.readWrite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readWrite ? 1231 : 1237);
            result = 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tenant other = (Tenant)obj;
            if (this.readWrite != other.readWrite) {
                return false;
            }
            return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
        }

        public String toString() {
            return System.lineSeparator() + "                tenant=" + this.tenant + System.lineSeparator() + "                readWrite=" + this.readWrite;
        }
    }
}

