/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.AllowlistValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class AllowlistApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security/api/allowlist"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_security/api/allowlist"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_plugins/_security/api/allowlist"));
    private static final String name = "config";

    @Inject
    public AllowlistApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (!this.isSuperAdmin()) {
            this.forbidden(channel, "API allowed only for super admin.");
            return;
        }
        super.handleApiRequest(channel, request, client);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        this.successResponse(channel, configuration);
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.DELETE);
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        SecurityDynamicConfiguration<?> existingConfiguration = this.load(this.getConfigName(), false);
        if (existingConfiguration.getSeqNo() < 0L) {
            this.forbidden(channel, "Security index need to be updated to support '" + this.getConfigName().toLCString() + "'. Use SecurityAdmin to populate.");
            return;
        }
        final boolean existed = existingConfiguration.exists(name);
        existingConfiguration.putCObject(name, DefaultObjectMapper.readTree(content, existingConfiguration.getImplementingClass()));
        AllowlistApiAction.saveAndUpdateConfigs(this.securityIndexName, client, this.getConfigName(), existingConfiguration, (ActionListener<IndexResponse>)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (existed) {
                    AllowlistApiAction.this.successResponse(channel, "'config' updated.");
                } else {
                    AllowlistApiAction.this.createdResponse(channel, "'config' created.");
                }
            }
        });
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ALLOWLIST;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new AllowlistValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return name;
    }

    @Override
    protected CType getConfigName() {
        return CType.ALLOWLIST;
    }
}

