/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.tenancy;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.action.tenancy.EmptyRequest;
import org.opensearch.security.action.tenancy.TenancyConfigRetrieveActions;
import org.opensearch.security.action.tenancy.TenancyConfigRetrieveResponse;
import org.opensearch.security.action.tenancy.TenancyConfigUpdateRequest;
import org.opensearch.security.action.tenancy.TenancyConfigs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TenancyConfigUpdateTransportAction
extends HandledTransportAction<TenancyConfigUpdateRequest, TenancyConfigRetrieveResponse> {
    private static final Logger log = LogManager.getLogger(TenancyConfigUpdateTransportAction.class);
    private final String securityIndex;
    private final ConfigurationRepository config;
    private final Client client;
    private final ThreadPool pool;

    @Inject
    public TenancyConfigUpdateTransportAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ConfigurationRepository config, ThreadPool pool, Client client) {
        super("cluster:feature/tenancy/config/update", transportService, actionFilters, TenancyConfigUpdateRequest::new);
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.config = config;
        this.client = client;
        this.pool = pool;
    }

    protected final SecurityDynamicConfiguration<?> load() {
        return this.config.getConfigurationsFromIndex(Collections.singleton(CType.CONFIG), false).get((Object)CType.CONFIG).deepClone();
    }

    private Set<String> getAcceptableDefaultTenants() {
        HashSet<String> acceptableDefaultTenants = new HashSet<String>();
        acceptableDefaultTenants.add("");
        acceptableDefaultTenants.add("Global");
        acceptableDefaultTenants.add("Private");
        return acceptableDefaultTenants;
    }

    private Set<String> getAllConfiguredTenantNames() {
        return this.config.getConfiguration(CType.TENANTS).getCEntries().keySet();
    }

    protected void validate(ConfigV7 updatedConfig) {
        if (!updatedConfig.dynamic.kibana.private_tenant_enabled && updatedConfig.dynamic.kibana.default_tenant.equals("Private")) {
            throw new IllegalArgumentException("Private tenant can not be disabled if it is the default tenant.");
        }
        Set<String> acceptableDefaultTenants = this.getAcceptableDefaultTenants();
        if (acceptableDefaultTenants.contains(updatedConfig.dynamic.kibana.default_tenant)) {
            return;
        }
        Set<String> availableTenants = this.getAllConfiguredTenantNames();
        if (!availableTenants.contains(updatedConfig.dynamic.kibana.default_tenant)) {
            throw new IllegalArgumentException(updatedConfig.dynamic.kibana.default_tenant + " can not be set to default tenant. Default tenant should be selected from one of the available tenants.");
        }
    }

    protected void doExecute(Task task, TenancyConfigUpdateRequest request, final ActionListener<TenancyConfigRetrieveResponse> listener) {
        SecurityDynamicConfiguration<?> dynamicConfig = this.load();
        ConfigV7 config = (ConfigV7)dynamicConfig.getCEntry("config");
        TenancyConfigs tenancyConfigs = request.getTenancyConfigs();
        if (tenancyConfigs.multitenancy_enabled != null) {
            config.dynamic.kibana.multitenancy_enabled = tenancyConfigs.multitenancy_enabled;
        }
        if (tenancyConfigs.private_tenant_enabled != null) {
            config.dynamic.kibana.private_tenant_enabled = tenancyConfigs.private_tenant_enabled;
        }
        if (tenancyConfigs.default_tenant != null) {
            config.dynamic.kibana.default_tenant = tenancyConfigs.default_tenant;
        }
        this.validate(config);
        dynamicConfig.putCEntry("config", config);
        try (final ThreadContext.StoredContext stashedContext = this.pool.getThreadContext().stashContext();){
            AbstractApiAction.saveAndUpdateConfigs(this.securityIndex, this.client, CType.CONFIG, dynamicConfig, new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    stashedContext.close();
                    try {
                        TenancyConfigUpdateTransportAction.this.client.execute((ActionType)TenancyConfigRetrieveActions.INSTANCE, (ActionRequest)new EmptyRequest(), listener);
                    }
                    catch (IOException ioe) {
                        log.error((Object)ioe);
                        listener.onFailure((Exception)ioe);
                    }
                }

                public void onFailure(Exception e) {
                    log.error((Object)e);
                    listener.onFailure(e);
                }
            });
        }
    }
}

