/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.tenancy;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.action.tenancy.TenancyConfigs;

public class TenancyConfigUpdateRequest
extends ActionRequest {
    private TenancyConfigs tenancyConfigs = new TenancyConfigs();
    private static final ConstructingObjectParser<TenancyConfigUpdateRequest, Void> PARSER = new ConstructingObjectParser(TenancyConfigUpdateRequest.class.getName(), args -> new TenancyConfigUpdateRequest((Boolean)args[0], (Boolean)args[1], (String)args[2]));

    public TenancyConfigUpdateRequest(StreamInput in) throws IOException {
        super(in);
        in.readOptionalBoolean();
        in.readOptionalBoolean();
        in.readOptionalString();
    }

    public TenancyConfigUpdateRequest(Boolean multitenancy_enabled, Boolean private_tenant_enabled, String default_tenant) {
        this.tenancyConfigs.multitenancy_enabled = multitenancy_enabled;
        this.tenancyConfigs.private_tenant_enabled = private_tenant_enabled;
        this.tenancyConfigs.default_tenant = default_tenant;
    }

    public TenancyConfigs getTenancyConfigs() {
        return this.tenancyConfigs;
    }

    public ActionRequestValidationException validate() {
        if (this.getTenancyConfigs() == null) {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            validationException.addValidationError("Missing tenancy configs");
            return validationException;
        }
        return null;
    }

    public static TenancyConfigUpdateRequest fromXContent(XContentParser parser) {
        return (TenancyConfigUpdateRequest)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("multitenancy_enabled", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("private_tenant_enabled", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("default_tenant", new String[0]));
    }
}

