/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.tenancy;

import java.util.Collections;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.action.tenancy.EmptyRequest;
import org.opensearch.security.action.tenancy.TenancyConfigRetrieveResponse;
import org.opensearch.security.action.tenancy.TenancyConfigs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TenancyConfigRetrieveTransportAction
extends HandledTransportAction<EmptyRequest, TenancyConfigRetrieveResponse> {
    private final ConfigurationRepository config;

    @Inject
    public TenancyConfigRetrieveTransportAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ConfigurationRepository config) {
        super("cluster:feature/tenancy/config/read", transportService, actionFilters, EmptyRequest::new);
        this.config = config;
    }

    protected final SecurityDynamicConfiguration<?> load() {
        return this.config.getConfigurationsFromIndex(Collections.singleton(CType.CONFIG), false).get((Object)CType.CONFIG).deepClone();
    }

    protected void doExecute(Task task, EmptyRequest request, ActionListener<TenancyConfigRetrieveResponse> listener) {
        SecurityDynamicConfiguration<?> dynamicConfig = this.load();
        ConfigV7 config = (ConfigV7)dynamicConfig.getCEntry("config");
        TenancyConfigs tenancyConfigs = new TenancyConfigs();
        tenancyConfigs.multitenancy_enabled = config.dynamic.kibana.multitenancy_enabled;
        tenancyConfigs.private_tenant_enabled = config.dynamic.kibana.private_tenant_enabled;
        tenancyConfigs.default_tenant = config.dynamic.kibana.default_tenant;
        listener.onResponse((Object)new TenancyConfigRetrieveResponse(tenancyConfigs));
    }
}

