/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.tenancy;

import java.io.IOException;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.action.tenancy.TenancyConfigs;

public class TenancyConfigRetrieveResponse
extends ActionResponse
implements ToXContentObject {
    public TenancyConfigs tenancyConfigs = new TenancyConfigs();

    public TenancyConfigRetrieveResponse(StreamInput in) throws IOException {
        super(in);
        this.tenancyConfigs.multitenancy_enabled = in.readOptionalBoolean();
        this.tenancyConfigs.private_tenant_enabled = in.readOptionalBoolean();
        this.tenancyConfigs.default_tenant = in.readOptionalString();
    }

    public TenancyConfigRetrieveResponse(TenancyConfigs tenancyConfigs) {
        this.tenancyConfigs = tenancyConfigs;
    }

    public TenancyConfigs getMultitenancyConfig() {
        return this.tenancyConfigs;
    }

    public Boolean getMultitenancyEnabled() {
        return this.tenancyConfigs.multitenancy_enabled;
    }

    public Boolean getPrivateTenantEnabled() {
        return this.tenancyConfigs.private_tenant_enabled;
    }

    public String getDefaultTenant() {
        return this.tenancyConfigs.default_tenant;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.getMultitenancyEnabled().booleanValue());
        out.writeBoolean(this.getPrivateTenantEnabled().booleanValue());
        out.writeString(this.getDefaultTenant());
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this, (boolean)true, (boolean)true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("multitenancy_enabled", this.getMultitenancyEnabled());
        builder.field("private_tenant_enabled", this.getPrivateTenantEnabled());
        builder.field("default_tenant", this.getDefaultTenant());
        builder.endObject();
        return builder;
    }
}

