/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.tenancy;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.security.action.tenancy.EmptyRequest;
import org.opensearch.security.action.tenancy.TenancyConfigRetrieveActions;
import org.opensearch.security.action.tenancy.TenancyConfigUpdateAction;
import org.opensearch.security.action.tenancy.TenancyConfigUpdateRequest;

public class TenancyConfigRestHandler
extends BaseRestHandler {
    public String getName() {
        return "Multi Tenancy actions to Retrieve / Update configs.";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security/api/tenancy/config"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_security/api/tenancy/config"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        switch (request.method()) {
            case GET: {
                return channel -> nodeClient.execute((ActionType)TenancyConfigRetrieveActions.INSTANCE, (ActionRequest)new EmptyRequest(), (ActionListener)new RestToXContentListener(channel));
            }
            case PUT: {
                return channel -> nodeClient.execute((ActionType)TenancyConfigUpdateAction.INSTANCE, (ActionRequest)TenancyConfigUpdateRequest.fromXContent(request.contentParser()), (ActionListener)new RestToXContentListener(channel));
            }
        }
        throw new RuntimeException("Not implemented");
    }
}

