/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap2;

import com.amazon.dlic.auth.ldap.LdapUser;
import com.amazon.dlic.auth.ldap.util.LdapHelper;
import com.amazon.dlic.auth.ldap.util.Utils;
import com.amazon.dlic.auth.ldap2.LDAPConnectionFactoryFactory;
import com.amazon.dlic.auth.ldap2.LDAPUserSearcher;
import com.amazon.dlic.util.SettingsBasedSSLConfigurator;
import com.google.common.collect.HashMultimap;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.ldaptive.pool.ConnectionPool;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.Destroyable;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;

public class LDAPAuthorizationBackend2
implements AuthorizationBackend,
Destroyable {
    static final int ZERO_PLACEHOLDER = 0;
    static final int ONE_PLACEHOLDER = 1;
    static final int TWO_PLACEHOLDER = 2;
    static final String DEFAULT_ROLEBASE = "";
    static final String DEFAULT_ROLESEARCH = "(member={0})";
    static final String DEFAULT_ROLENAME = "name";
    static final String DEFAULT_USERROLENAME = "memberOf";
    protected static final Logger log = LogManager.getLogger(LDAPAuthorizationBackend2.class);
    private final Settings settings;
    private final WildcardMatcher skipUsersMatcher;
    private final WildcardMatcher nestedRoleMatcher;
    private final List<Map.Entry<String, Settings>> roleBaseSettings;
    private ConnectionPool connectionPool;
    private ConnectionFactory connectionFactory;
    private LDAPUserSearcher userSearcher;
    private final String[] returnAttributes;
    private final boolean shouldFollowReferrals;

    public LDAPAuthorizationBackend2(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        this.settings = settings;
        this.skipUsersMatcher = WildcardMatcher.from(settings.getAsList("skip_users"));
        this.nestedRoleMatcher = settings.getAsBoolean("resolve_nested_roles", Boolean.valueOf(false)) != false ? WildcardMatcher.from(settings.getAsList("nested_role_filter")) : null;
        this.roleBaseSettings = LDAPAuthorizationBackend2.getRoleSearchSettings(settings);
        LDAPConnectionFactoryFactory ldapConnectionFactoryFactory = new LDAPConnectionFactoryFactory(settings, configPath);
        this.connectionPool = ldapConnectionFactoryFactory.createConnectionPool();
        this.connectionFactory = ldapConnectionFactoryFactory.createConnectionFactory(this.connectionPool);
        this.userSearcher = new LDAPUserSearcher(settings);
        this.returnAttributes = settings.getAsList("custom_return_attributes", Arrays.asList(ReturnAttributes.ALL.value())).toArray(new String[0]);
        this.shouldFollowReferrals = settings.getAsBoolean("follow_referrals", Boolean.valueOf(true));
    }

    private static List<Map.Entry<String, Settings>> getRoleSearchSettings(Settings settings) {
        Map groupedSettings = settings.getGroups("roles", true);
        if (!groupedSettings.isEmpty()) {
            return Utils.getOrderedBaseSettings(groupedSettings);
        }
        return LDAPAuthorizationBackend2.convertOldStyleSettingsToNewStyle(settings);
    }

    private static List<Map.Entry<String, Settings>> convertOldStyleSettingsToNewStyle(Settings settings) {
        HashMap<String, Settings> result = new HashMap<String, Settings>(1);
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("rolebase", DEFAULT_ROLEBASE));
        settingsBuilder.put("search", settings.get("rolesearch", DEFAULT_ROLESEARCH));
        result.put("convertedOldStyleSettings", settingsBuilder.build());
        return Collections.singletonList(result.entrySet().iterator().next());
    }

    @Override
    public void fillRoles(final User user, final AuthCredentials optionalAuthCreds) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    LDAPAuthorizationBackend2.this.fillRoles0(user, optionalAuthCreds);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof OpenSearchSecurityException) {
                throw (OpenSearchSecurityException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private void fillRoles0(User user, AuthCredentials optionalAuthCreds) throws OpenSearchSecurityException {
        boolean isTraceEnabled;
        String originalUserName;
        String authenticatedUser;
        if (user == null) {
            return;
        }
        LdapEntry entry = null;
        String dn = null;
        if (user instanceof LdapUser) {
            entry = ((LdapUser)user).getUserEntry();
            dn = entry.getDn();
            authenticatedUser = entry.getDn();
            originalUserName = ((LdapUser)user).getOriginalUsername();
        } else {
            authenticatedUser = user.getName();
            originalUserName = user.getName();
        }
        boolean rolesearchEnabled = this.settings.getAsBoolean("rolesearch_enabled", Boolean.valueOf(true));
        boolean isDebugEnabled = log.isDebugEnabled();
        if (isDebugEnabled) {
            log.debug("Try to get roles for {}", (Object)authenticatedUser);
        }
        if (isTraceEnabled = log.isTraceEnabled()) {
            log.trace("user class: {}", user.getClass());
            log.trace("authenticatedUser: {}", (Object)authenticatedUser);
            log.trace("originalUserName: {}", (Object)originalUserName);
            log.trace("entry: {}", (Object)String.valueOf(entry));
            log.trace("dn: {}", (Object)dn);
        }
        if (this.skipUsersMatcher.test(authenticatedUser)) {
            if (isDebugEnabled) {
                log.debug("Skipped search roles of user {}/{}", (Object)authenticatedUser, (Object)originalUserName);
            }
            return;
        }
        try (Connection connection = this.connectionFactory.getConnection();){
            connection.open();
            if (entry == null || dn == null) {
                if (this.isValidDn(authenticatedUser)) {
                    if (isTraceEnabled) {
                        log.trace("{} is a valid DN", (Object)authenticatedUser);
                    }
                    if ((entry = LdapHelper.lookup(connection, authenticatedUser, this.returnAttributes, this.shouldFollowReferrals)) == null) {
                        throw new OpenSearchSecurityException("No user '" + authenticatedUser + "' found", new Object[0]);
                    }
                } else {
                    entry = this.userSearcher.exists(connection, user.getName(), this.returnAttributes, this.shouldFollowReferrals);
                    if (isTraceEnabled) {
                        log.trace("{} is not a valid DN and was resolved to {}", (Object)authenticatedUser, (Object)entry);
                    }
                    if (entry == null || entry.getDn() == null) {
                        throw new OpenSearchSecurityException("No user " + authenticatedUser + " found", new Object[0]);
                    }
                }
                dn = entry.getDn();
                if (isTraceEnabled) {
                    log.trace("User found with DN {}", (Object)dn);
                }
            }
            HashSet<LdapName> ldapRoles = new HashSet<LdapName>(150);
            HashSet<String> nonLdapRoles = new HashSet<String>(150);
            HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
            String userRoleNames = this.settings.get("userrolename", DEFAULT_USERROLENAME);
            if (isTraceEnabled) {
                log.trace("raw userRoleName(s): {}", (Object)userRoleNames);
            }
            for (String userRoleName : userRoleNames.split(",")) {
                String roleName = userRoleName.trim();
                if (entry.getAttribute(roleName) == null) continue;
                Iterator userRoles = entry.getAttribute(roleName).getStringValues();
                Iterator iterator = userRoles.iterator();
                while (iterator.hasNext()) {
                    String possibleRoleDN = (String)iterator.next();
                    if (this.isValidDn(possibleRoleDN)) {
                        LdapName ldapName = new LdapName(possibleRoleDN);
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                        continue;
                    }
                    nonLdapRoles.add(possibleRoleDN);
                }
            }
            if (isTraceEnabled) {
                log.trace("User attr. ldap roles count: {}", (Object)ldapRoles.size());
                log.trace("User attr. ldap roles {}", ldapRoles);
                log.trace("User attr. non-ldap roles count: {}", (Object)nonLdapRoles.size());
                log.trace("User attr. non-ldap roles {}", nonLdapRoles);
            }
            String roleName = this.settings.get("rolename", DEFAULT_ROLENAME);
            if (isTraceEnabled) {
                log.trace("roleName: {}", (Object)roleName);
            }
            String userRoleAttributeName = this.settings.get("userroleattribute", null);
            if (isTraceEnabled) {
                log.trace("userRoleAttribute: {}", (Object)userRoleAttributeName);
                log.trace("rolesearch: {}", (Object)this.settings.get("rolesearch", DEFAULT_ROLESEARCH));
            }
            String userRoleAttributeValue = null;
            LdapAttribute userRoleAttribute = entry.getAttribute(userRoleAttributeName);
            if (userRoleAttribute != null) {
                userRoleAttributeValue = Utils.getSingleStringValue(userRoleAttribute);
            }
            if (rolesearchEnabled) {
                String escapedDn = dn;
                for (Map.Entry entry2 : this.roleBaseSettings) {
                    Settings roleSearchSettings = (Settings)entry2.getValue();
                    SearchFilter f = new SearchFilter();
                    f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                    f.setParameter(0, (Object)escapedDn);
                    f.setParameter(1, (Object)originalUserName);
                    f.setParameter(2, userRoleAttributeValue == null ? Integer.valueOf(2) : userRoleAttributeValue);
                    List<LdapEntry> rolesResult = LdapHelper.search(connection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE, this.returnAttributes, this.shouldFollowReferrals);
                    if (isTraceEnabled) {
                        log.trace("Results for LDAP group search for {} in base {}:\n{}", (Object)escapedDn, entry2.getKey(), rolesResult);
                    }
                    if (rolesResult == null || rolesResult.isEmpty()) continue;
                    for (LdapEntry searchResultEntry : rolesResult) {
                        LdapName ldapName = new LdapName(searchResultEntry.getDn());
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.put((Object)ldapName, (Object)entry2);
                    }
                }
            }
            if (isTraceEnabled) {
                log.trace("roles count total {}", (Object)ldapRoles.size());
            }
            if (this.nestedRoleMatcher != null) {
                if (isTraceEnabled) {
                    log.trace("Evaluate nested roles");
                }
                HashSet<LdapName> nestedReturn = new HashSet<LdapName>(ldapRoles);
                for (LdapName ldapName : ldapRoles) {
                    Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                    if (nameRoleSearchBaseKeys == null) {
                        log.error("Could not find roleSearchBaseKeys for {}; existing: {}", (Object)ldapName, (Object)resultRoleSearchBaseKeys);
                        continue;
                    }
                    Set<LdapName> nestedRoles = this.resolveNestedRoles(ldapName, connection, userRoleNames, 0, rolesearchEnabled, nameRoleSearchBaseKeys);
                    if (isTraceEnabled) {
                        log.trace("{} nested roles for {}", (Object)nestedRoles.size(), (Object)ldapName);
                    }
                    nestedReturn.addAll(nestedRoles);
                }
                for (LdapName ldapName : nestedReturn) {
                    String role = this.getRoleFromEntry(connection, ldapName, roleName);
                    if (!Strings.isNullOrEmpty((String)role)) {
                        user.addRole(role);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)ldapName);
                }
            } else {
                for (LdapName roleLdapName : ldapRoles) {
                    String string = this.getRoleFromEntry(connection, roleLdapName, roleName);
                    if (!Strings.isNullOrEmpty((String)string)) {
                        user.addRole(string);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)roleLdapName);
                }
            }
            for (String nonLdapRoleName : nonLdapRoles) {
                user.addRole(nonLdapRoleName);
            }
            if (isDebugEnabled) {
                log.debug("Roles for {} -> {}", (Object)user.getName(), user.getRoles());
            }
            if (isTraceEnabled) {
                log.trace("returned user: {}", (Object)user);
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("Unable to fill user roles due to ", (Throwable)e);
            }
            throw new OpenSearchSecurityException(e.toString(), e, new Object[0]);
        }
    }

    protected Set<LdapName> resolveNestedRoles(LdapName roleDn, Connection ldapConnection, String userRoleName, int depth, boolean rolesearchEnabled, Set<Map.Entry<String, Settings>> roleSearchBaseSettingsSet) throws OpenSearchSecurityException, LdapException {
        boolean isTraceEnabled = log.isTraceEnabled();
        if (this.nestedRoleMatcher.test(roleDn.toString())) {
            if (isTraceEnabled) {
                log.trace("Filter nested role {}", (Object)roleDn);
            }
            return Collections.emptySet();
        }
        ++depth;
        HashSet<LdapName> result = new HashSet<LdapName>(20);
        HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
        LdapEntry e0 = LdapHelper.lookup(ldapConnection, roleDn.toString(), this.returnAttributes, this.shouldFollowReferrals);
        boolean isDebugEnabled = log.isDebugEnabled();
        if (e0.getAttribute(userRoleName) != null) {
            Collection userRoles = e0.getAttribute(userRoleName).getStringValues();
            for (String string : userRoles) {
                if (this.isValidDn(string)) {
                    try {
                        LdapName ldapName = new LdapName(string);
                        result.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                    }
                    catch (InvalidNameException ldapName) {}
                    continue;
                }
                if (!isDebugEnabled) continue;
                log.debug("Cannot add {} as a role because its not a valid dn", (Object)string);
            }
        }
        if (isTraceEnabled) {
            log.trace("result nested attr count for depth {} : {}", (Object)depth, (Object)result.size());
        }
        if (rolesearchEnabled) {
            String escapedDn = roleDn.toString();
            for (Map.Entry entry : Utils.getOrderedBaseSettings(roleSearchBaseSettingsSet)) {
                Settings roleSearchSettings = (Settings)entry.getValue();
                SearchFilter f = new SearchFilter();
                f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                f.setParameter(0, (Object)escapedDn);
                f.setParameter(1, (Object)escapedDn);
                List<LdapEntry> foundEntries = LdapHelper.search(ldapConnection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE, this.returnAttributes, this.shouldFollowReferrals);
                if (isTraceEnabled) {
                    log.trace("Results for LDAP group search for {} in base {}:\n{}", (Object)escapedDn, entry.getKey(), foundEntries);
                }
                if (foundEntries == null) continue;
                for (LdapEntry entry2 : foundEntries) {
                    try {
                        LdapName dn = new LdapName(entry2.getDn());
                        result.add(dn);
                        resultRoleSearchBaseKeys.put((Object)dn, (Object)entry);
                    }
                    catch (InvalidNameException e) {
                        throw new LdapException((Exception)e);
                    }
                }
            }
        }
        int maxDepth = 30;
        try {
            maxDepth = this.settings.getAsInt("max_nested_depth", Integer.valueOf(30));
        }
        catch (Exception e) {
            log.error("max_nested_depth is not parseable: ", (Throwable)e);
        }
        if (depth < maxDepth) {
            for (LdapName ldapName : new HashSet<LdapName>(result)) {
                Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                if (nameRoleSearchBaseKeys == null) {
                    log.error("Could not find roleSearchBaseKeys for {}; existing: {}", (Object)ldapName, (Object)resultRoleSearchBaseKeys);
                    continue;
                }
                Set<LdapName> in = this.resolveNestedRoles(ldapName, ldapConnection, userRoleName, depth, rolesearchEnabled, nameRoleSearchBaseKeys);
                result.addAll(in);
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return "ldap";
    }

    private boolean isValidDn(String dn) {
        if (Strings.isNullOrEmpty((String)dn)) {
            return false;
        }
        try {
            new LdapName(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getRoleFromEntry(Connection ldapConnection, LdapName ldapName, String role) {
        if (ldapName == null || Strings.isNullOrEmpty((String)role)) {
            return null;
        }
        if ("dn".equalsIgnoreCase(role)) {
            return ldapName.toString();
        }
        try {
            LdapAttribute roleAttribute;
            LdapEntry roleEntry = LdapHelper.lookup(ldapConnection, ldapName.toString(), this.returnAttributes, this.shouldFollowReferrals);
            if (roleEntry != null && (roleAttribute = roleEntry.getAttribute(role)) != null) {
                return Utils.getSingleStringValue(roleAttribute);
            }
        }
        catch (LdapException e) {
            log.error("Unable to handle role {} because of ", (Object)ldapName, (Object)e);
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }
}

