/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.jwt.keybyoidc;

import com.amazon.dlic.auth.http.jwt.keybyoidc.BadCredentialsException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JwtVerifier {
    private static final Logger log = LogManager.getLogger(JwtVerifier.class);
    private final KeyProvider keyProvider;
    private final int clockSkewToleranceSeconds;

    public JwtVerifier(KeyProvider keyProvider, int clockSkewToleranceSeconds) {
        this.keyProvider = keyProvider;
        this.clockSkewToleranceSeconds = clockSkewToleranceSeconds;
    }

    public JwtToken getVerifiedJwtToken(String encodedJwt) throws BadCredentialsException {
        try {
            JwsSignatureVerifier signatureVerifier;
            boolean signatureValid;
            JsonWebKey key;
            String escapedKid;
            JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(encodedJwt);
            JwtToken jwt = jwtConsumer.getJwtToken();
            String kid = escapedKid = jwt.getJwsHeaders().getKeyId();
            if (!Strings.isNullOrEmpty((String)kid)) {
                kid = StringEscapeUtils.unescapeJava((String)escapedKid);
            }
            if ((key = this.keyProvider.getKey(kid)).getAlgorithm() == null && key.getPublicKeyUse() == PublicKeyUse.SIGN && key.getKeyType() == KeyType.RSA) {
                key.setAlgorithm(jwt.getJwsHeaders().getAlgorithm());
            }
            if (!(signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier = this.getInitializedSignatureVerifier(key, jwt))) && Strings.isNullOrEmpty((String)kid)) {
                key = this.keyProvider.getKeyAfterRefresh(null);
                signatureVerifier = this.getInitializedSignatureVerifier(key, jwt);
                signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier);
            }
            if (!signatureValid) {
                throw new BadCredentialsException("Invalid JWT signature");
            }
            this.validateClaims(jwt);
            return jwt;
        }
        catch (JwtException e) {
            throw new BadCredentialsException(e.getMessage(), e);
        }
    }

    private void validateSignatureAlgorithm(JsonWebKey key, JwtToken jwt) throws BadCredentialsException {
        SignatureAlgorithm tokenAlgorithm;
        if (Strings.isNullOrEmpty((String)key.getAlgorithm())) {
            return;
        }
        SignatureAlgorithm keyAlgorithm = SignatureAlgorithm.getAlgorithm((String)key.getAlgorithm());
        if (!keyAlgorithm.equals((Object)(tokenAlgorithm = SignatureAlgorithm.getAlgorithm((String)jwt.getJwsHeaders().getAlgorithm())))) {
            throw new BadCredentialsException("Algorithm of JWT does not match algorithm of JWK (" + keyAlgorithm + " != " + tokenAlgorithm + ")");
        }
    }

    private JwsSignatureVerifier getInitializedSignatureVerifier(JsonWebKey key, JwtToken jwt) throws BadCredentialsException, JwtException {
        this.validateSignatureAlgorithm(key, jwt);
        JwsSignatureVerifier result = JwsUtils.getSignatureVerifier((JsonWebKey)key, (SignatureAlgorithm)jwt.getJwsHeaders().getSignatureAlgorithm());
        if (result == null) {
            throw new BadCredentialsException("Cannot verify JWT");
        }
        return result;
    }

    private void validateClaims(JwtToken jwt) throws BadCredentialsException, JwtException {
        JwtClaims claims = jwt.getClaims();
        if (claims != null) {
            JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)this.clockSkewToleranceSeconds, (boolean)false);
            JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)this.clockSkewToleranceSeconds, (boolean)false);
        }
    }
}

