/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class DynamicResponseHeaderFilter
implements Filter {
    @Nonnull
    @NonnullElements
    private Map<String, String> headers = Collections.emptyMap();
    @Nonnull
    @NonnullElements
    private Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> callbacks = Collections.emptyList();

    public void setHeaders(@Nullable @NonnullElements Map<String, String> map) {
        if (map != null) {
            this.headers = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String trimmedName = StringSupport.trimOrNull(entry.getKey());
                String trimmedValue = StringSupport.trimOrNull(entry.getValue());
                if (trimmedName == null || trimmedValue == null) continue;
                this.headers.put(trimmedName, trimmedValue);
            }
        } else {
            this.headers = Collections.emptyMap();
        }
    }

    public void setCallbacks(@Nullable @NonnullElements Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> theCallbacks) {
        this.callbacks = theCallbacks != null ? new ArrayList<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>>(Collections2.filter(theCallbacks, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.headers.isEmpty() && this.callbacks.isEmpty()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new ResponseProxy((HttpServletRequest)request, (HttpServletResponse)response));
    }

    private class ResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private final HttpServletRequest request;

        public ResponseProxy(@Nonnull HttpServletRequest req, HttpServletResponse response) {
            super(response);
            this.request = req;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.addHeaders();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.addHeaders();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.addHeaders();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.addHeaders();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.addHeaders();
            super.sendRedirect(location);
        }

        private void addHeaders() {
            for (Map.Entry header : DynamicResponseHeaderFilter.this.headers.entrySet()) {
                ((HttpServletResponse)this.getResponse()).addHeader((String)header.getKey(), (String)header.getValue());
            }
            if (!DynamicResponseHeaderFilter.this.callbacks.isEmpty()) {
                Pair<HttpServletRequest, HttpServletResponse> p = new Pair<HttpServletRequest, HttpServletResponse>(this.request, (HttpServletResponse)this.getResponse());
                for (Function callback : DynamicResponseHeaderFilter.this.callbacks) {
                    callback.apply(p);
                }
            }
        }
    }
}

