/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AuditLogSink;

public final class Log4JSink
extends AuditLogSink {
    final Logger auditLogger;
    final String loggerName;
    final Level logLevel;
    final boolean enabled;

    public Log4JSink(String name, Settings settings, String settingsPrefix, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.loggerName = settings.get(settingsPrefix + ".log4j.logger_name", "sgaudit");
        this.auditLogger = LogManager.getLogger((String)this.loggerName);
        this.logLevel = Level.toLevel((String)settings.get(settingsPrefix + ".log4j.level", "INFO").toUpperCase());
        this.enabled = this.isLogLevelEnabled(this.auditLogger, this.logLevel);
    }

    @Override
    public boolean isHandlingBackpressure() {
        return !this.enabled;
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (this.enabled) {
            this.logAtLevel(this.auditLogger, this.logLevel, msg.toJson());
        }
        return true;
    }

    private boolean isLogLevelEnabled(Logger logger, Level level) {
        boolean isEnabled = false;
        switch (level.toString()) {
            case "TRACE": {
                isEnabled = logger.isTraceEnabled();
            }
            case "DEBUG": {
                isEnabled = logger.isDebugEnabled();
            }
            case "INFO": {
                isEnabled = logger.isInfoEnabled();
            }
            case "WARN": {
                isEnabled = logger.isWarnEnabled();
            }
            case "ERROR": {
                isEnabled = logger.isErrorEnabled();
            }
        }
        return isEnabled;
    }

    private void logAtLevel(Logger logger, Level level, String msg) {
        switch (level.toString()) {
            case "TRACE": {
                logger.trace(msg);
            }
            case "DEBUG": {
                logger.debug(msg);
            }
            case "INFO": {
                logger.info(msg);
            }
            case "WARN": {
                logger.warn(msg);
            }
            case "ERROR": {
                logger.error(msg);
            }
        }
    }
}

