/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CorrelationIdMismatchException;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public abstract class AbstractResponse
implements AbstractRequestResponse {
    public static final int DEFAULT_THROTTLE_TIME = 0;
    private final ApiKeys apiKey;

    protected AbstractResponse(ApiKeys apiKey) {
        this.apiKey = apiKey;
    }

    public final Send toSend(ResponseHeader header, short version) {
        return SendBuilder.buildResponseSend(header, this.data(), version);
    }

    final ByteBuffer serializeWithHeader(ResponseHeader header, short version) {
        return RequestUtils.serialize(header.data(), header.headerVersion(), this.data(), version);
    }

    final ByteBuffer serialize(short version) {
        return MessageUtil.toByteBuffer(this.data(), version);
    }

    public abstract Map<Errors, Integer> errorCounts();

    protected Map<Errors, Integer> errorCounts(Errors error) {
        return Collections.singletonMap(error, 1);
    }

    protected Map<Errors, Integer> errorCounts(Stream<Errors> errors) {
        return errors.collect(Collectors.groupingBy(e -> e, Collectors.summingInt(e -> 1)));
    }

    protected Map<Errors, Integer> errorCounts(Collection<Errors> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Errors error : errors) {
            this.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    protected Map<Errors, Integer> apiErrorCounts(Map<?, ApiError> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (ApiError apiError : errors.values()) {
            this.updateErrorCounts(errorCounts, apiError.error());
        }
        return errorCounts;
    }

    protected void updateErrorCounts(Map<Errors, Integer> errorCounts, Errors error) {
        Integer count = errorCounts.getOrDefault((Object)error, 0);
        errorCounts.put(error, count + 1);
    }

    public static AbstractResponse parseResponse(ByteBuffer buffer, RequestHeader requestHeader) {
        ApiKeys apiKey = requestHeader.apiKey();
        short apiVersion = requestHeader.apiVersion();
        ResponseHeader responseHeader = ResponseHeader.parse(buffer, apiKey.responseHeaderVersion(apiVersion));
        if (requestHeader.correlationId() != responseHeader.correlationId()) {
            throw new CorrelationIdMismatchException("Correlation id for response (" + responseHeader.correlationId() + ") does not match request (" + requestHeader.correlationId() + "), request header: " + requestHeader, requestHeader.correlationId(), responseHeader.correlationId());
        }
        return AbstractResponse.parseResponse(apiKey, buffer, apiVersion);
    }

    public static AbstractResponse parseResponse(ApiKeys apiKey, ByteBuffer responseBuffer, short version) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceResponse.parse(responseBuffer, version);
            }
            case FETCH: {
                return FetchResponse.parse(responseBuffer, version);
            }
            case LIST_OFFSETS: {
                return ListOffsetsResponse.parse(responseBuffer, version);
            }
            case METADATA: {
                return MetadataResponse.parse(responseBuffer, version);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitResponse.parse(responseBuffer, version);
            }
            case OFFSET_FETCH: {
                return OffsetFetchResponse.parse(responseBuffer, version);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorResponse.parse(responseBuffer, version);
            }
            case JOIN_GROUP: {
                return JoinGroupResponse.parse(responseBuffer, version);
            }
            case HEARTBEAT: {
                return HeartbeatResponse.parse(responseBuffer, version);
            }
            case LEAVE_GROUP: {
                return LeaveGroupResponse.parse(responseBuffer, version);
            }
            case SYNC_GROUP: {
                return SyncGroupResponse.parse(responseBuffer, version);
            }
            case STOP_REPLICA: {
                return StopReplicaResponse.parse(responseBuffer, version);
            }
            case CONTROLLED_SHUTDOWN: {
                return ControlledShutdownResponse.parse(responseBuffer, version);
            }
            case UPDATE_METADATA: {
                return UpdateMetadataResponse.parse(responseBuffer, version);
            }
            case LEADER_AND_ISR: {
                return LeaderAndIsrResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsResponse.parse(responseBuffer, version);
            }
            case LIST_GROUPS: {
                return ListGroupsResponse.parse(responseBuffer, version);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeResponse.parse(responseBuffer, version);
            }
            case API_VERSIONS: {
                return ApiVersionsResponse.parse(responseBuffer, version);
            }
            case CREATE_TOPICS: {
                return CreateTopicsResponse.parse(responseBuffer, version);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsResponse.parse(responseBuffer, version);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsResponse.parse(responseBuffer, version);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdResponse.parse(responseBuffer, version);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochResponse.parse(responseBuffer, version);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnResponse.parse(responseBuffer, version);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnResponse.parse(responseBuffer, version);
            }
            case END_TXN: {
                return EndTxnResponse.parse(responseBuffer, version);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersResponse.parse(responseBuffer, version);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsResponse.parse(responseBuffer, version);
            }
            case CREATE_ACLS: {
                return CreateAclsResponse.parse(responseBuffer, version);
            }
            case DELETE_ACLS: {
                return DeleteAclsResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsResponse.parse(responseBuffer, version);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsResponse.parse(responseBuffer, version);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsResponse.parse(responseBuffer, version);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateResponse.parse(responseBuffer, version);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsResponse.parse(responseBuffer, version);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenResponse.parse(responseBuffer, version);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenResponse.parse(responseBuffer, version);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenResponse.parse(responseBuffer, version);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsResponse.parse(responseBuffer, version);
            }
            case ELECT_LEADERS: {
                return ElectLeadersResponse.parse(responseBuffer, version);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsResponse.parse(responseBuffer, version);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsResponse.parse(responseBuffer, version);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsResponse.parse(responseBuffer, version);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasResponse.parse(responseBuffer, version);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsResponse.parse(responseBuffer, version);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsResponse.parse(responseBuffer, version);
            }
            case VOTE: {
                return VoteResponse.parse(responseBuffer, version);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochResponse.parse(responseBuffer, version);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumResponse.parse(responseBuffer, version);
            }
            case ALTER_ISR: {
                return AlterIsrResponse.parse(responseBuffer, version);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesResponse.parse(responseBuffer, version);
            }
            case ENVELOPE: {
                return EnvelopeResponse.parse(responseBuffer, version);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersResponse.parse(responseBuffer, version);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationResponse.parse(responseBuffer, version);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatResponse.parse(responseBuffer, version);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerResponse.parse(responseBuffer, version);
            }
            case DESCRIBE_TRANSACTIONS: {
                return DescribeTransactionsResponse.parse(responseBuffer, version);
            }
            case LIST_TRANSACTIONS: {
                return ListTransactionsResponse.parse(responseBuffer, version);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return AllocateProducerIdsResponse.parse(responseBuffer, version);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public boolean shouldClientThrottle(short version) {
        return false;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public abstract int throttleTimeMs();

    public String toString() {
        return this.data().toString();
    }
}

